/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.sunutils.db;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.log.Log;
import cn.sanenen.sunutils.db.DbUtil;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class BaseDao<T>
extends TypeReference<T> {
    protected final Log log = Log.get(((Object)((Object)this)).getClass());
    protected final Db db;
    private final Class<T> tClass = TypeUtil.getClass((Type)this.getType());
    private final String tableName = DbUtil.getTableName(this.tClass);

    public BaseDao(DataSource dataSource) {
        this.db = Db.use((DataSource)dataSource);
    }

    public BaseDao(String groupName) {
        this.db = Db.use((String)groupName);
    }

    public BaseDao(Db db) {
        this.db = db;
    }

    public Db db() {
        return this.db;
    }

    public List<T> query(String sql, Object ... params) throws SQLException {
        List query = this.db.query(sql, params);
        return this.toBean(query);
    }

    public T queryOne(String sql, Object ... params) throws SQLException {
        Entity entity = this.db.queryOne(sql, params);
        return (T)entity.toBean(this.tClass);
    }

    public List<T> list() throws SQLException {
        List all = this.db.findAll(Entity.create((String)this.tableName));
        return this.toBean(all);
    }

    private List<T> toBean(List<Entity> all) {
        return all.stream().map(entity -> {
            try {
                return entity.toBeanWithCamelCase(this.tClass.newInstance());
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public int save(T t) throws SQLException {
        return this.db.insert(DbUtil.toEntity(t));
    }

    public int[] saveBatch(Collection<T> entityList) throws SQLException {
        List<Entity> entity = DbUtil.toEntity(entityList);
        return this.db.insert(entity);
    }

    public int del(String field, Object value) throws SQLException {
        return this.db.del(this.tableName, field, value);
    }

    public int updateById(T record) throws SQLException {
        return this.updateById(record, (T)true);
    }

    public int updateById(T record, boolean ignoreNullValue) throws SQLException {
        return this.updateById(record, ignoreNullValue, null);
    }

    public int updateById(T record, T dbRecord) throws SQLException {
        return this.updateById(record, true, dbRecord);
    }

    public int updateById(T record, boolean ignoreNullValue, T dbRecord) throws SQLException {
        return this.update(DbUtil.toEntity(record, ignoreNullValue), DbUtil.getIdEntity(record), DbUtil.toEntity(dbRecord, ignoreNullValue));
    }

    public int update(T record, T where) throws SQLException {
        return this.update(record, where, (T)true);
    }

    public int update(T record, T where, boolean ignoreNullValue) throws SQLException {
        return this.update(record, where, ignoreNullValue, null);
    }

    public int update(T record, T where, T dbRecord) throws SQLException {
        return this.update(record, where, true, dbRecord);
    }

    public int update(T record, T where, boolean ignoreNullValue, T dbRecord) throws SQLException {
        return this.update(DbUtil.toEntity(record, ignoreNullValue), DbUtil.toEntity(where, false), DbUtil.toEntity(dbRecord, ignoreNullValue));
    }

    private int update(Entity recordEntity, Entity whereEntity, Entity dbRecordEntity) throws SQLException {
        if (whereEntity == null || recordEntity == null) {
            return 0;
        }
        if (dbRecordEntity != null) {
            recordEntity.removeEqual((Dict)dbRecordEntity, new String[0]);
        }
        return this.db.update(recordEntity, whereEntity);
    }
}

