/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.thread;

import cn.hutool.log.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;

public class AsyncBlockedThreadPoolExecutor
extends ThreadPoolTaskExecutor {
    private static final Log log = Log.get();
    private final Semaphore semaphore;

    public AsyncBlockedThreadPoolExecutor(int poolSize) {
        super.setCorePoolSize(poolSize);
        this.semaphore = new Semaphore(poolSize);
    }

    public <T> Future<T> submit(Callable<T> task) {
        try {
            this.semaphore.acquire();
            ListenableFutureTask listenableFutureTask = new ListenableFutureTask(task);
            listenableFutureTask.addCallback((ListenableFutureCallback)new ListenableFutureCallback<Object>(){

                public void onFailure(Throwable ex) {
                    AsyncBlockedThreadPoolExecutor.this.semaphore.release();
                    log.error(ex);
                }

                public void onSuccess(Object result) {
                    AsyncBlockedThreadPoolExecutor.this.semaphore.release();
                }
            });
            super.submitListenable((Runnable)listenableFutureTask);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
    }
}

