/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.queue;

import cn.hutool.log.Log;
import cn.sanenen.queue.QueueConstant;
import cn.sanenen.queue.data.DataEntity;
import cn.sanenen.queue.data.DataIndex;
import cn.sanenen.queue.data.FileRunner;
import cn.sanenen.queue.exception.FileEOFException;
import cn.sanenen.queue.exception.FileFormatException;
import java.io.File;
import java.io.IOException;

public class SQueue {
    private static final Log log = Log.get();
    private static final String dbName = "index.i";
    private final int fileLimitLength;
    private final String path;
    private final DataIndex db;
    private DataEntity writerHandle;
    private DataEntity readerHandle;
    private int readerIndex;
    private int writerIndex;
    private final Object lock = new Object();

    protected SQueue(String path) throws Exception {
        this(path, 0x3200000);
    }

    protected SQueue(String dir, int fileLimitLength) throws Exception {
        this.fileLimitLength = fileLimitLength;
        File fileDir = new File(dir);
        if (!(fileDir.exists() || fileDir.isDirectory() || fileDir.mkdirs())) {
            throw new IOException("create dir error");
        }
        this.path = fileDir.getAbsolutePath();
        this.db = new DataIndex(this.path + QueueConstant.FILE_SEPARATOR + dbName);
        this.writerIndex = this.db.getWriterIndex();
        this.readerIndex = this.db.getReaderIndex();
        this.writerHandle = this.createLogEntity(this.getLogPath(this.writerIndex), this.writerIndex);
        this.readerHandle = this.readerIndex == this.writerIndex ? this.writerHandle : this.createLogEntity(this.getLogPath(this.readerIndex), this.readerIndex);
    }

    private DataEntity createLogEntity(String dbpath, int fileNumber) throws IOException, FileFormatException {
        return new DataEntity(dbpath, fileNumber, this.fileLimitLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateNextLogWriter() throws IOException, FileFormatException {
        ++this.writerIndex;
        Object object = this.lock;
        synchronized (object) {
            if (this.readerHandle != this.writerHandle) {
                this.writerHandle.close();
            }
            this.db.putWriterIndex(this.writerIndex);
            this.writerHandle = this.readerHandle.getCurrentFileNumber() == this.writerIndex ? this.readerHandle : this.createLogEntity(this.getLogPath(this.writerIndex), this.writerIndex);
        }
    }

    private String getLogPath(int index) {
        return this.path + QueueConstant.FILE_SEPARATOR + "data_" + index + ".d";
    }

    public synchronized void add(byte[] message) throws IOException, FileFormatException {
        short status = this.writerHandle.write(message);
        if (status == 3) {
            this.rotateNextLogWriter();
            status = this.writerHandle.write(message);
        }
        if (status == 1) {
            this.db.incrementSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] readNextAndRemove() throws IOException, FileFormatException {
        byte[] b = null;
        try {
            b = this.readerHandle.readNextAndRemove();
        }
        catch (FileEOFException e) {
            int deleteNum = this.readerHandle.getCurrentFileNumber();
            int nextFile = deleteNum + 1;
            this.readerHandle.close();
            FileRunner.addDeleteFile(this.getLogPath(deleteNum));
            this.db.putReaderIndex(nextFile);
            Object object = this.lock;
            synchronized (object) {
                this.readerHandle = this.writerHandle.getCurrentFileNumber() == nextFile && this.writerHandle.getMappedByteBuffer() != null ? this.writerHandle : this.createLogEntity(this.getLogPath(nextFile), nextFile);
            }
            try {
                b = this.readerHandle.readNextAndRemove();
            }
            catch (FileEOFException e1) {
                log.error("read new log file FileEOFException error occurred", new Object[]{e1});
            }
        }
        if (b != null) {
            this.db.decrementSize();
        }
        return b;
    }

    public void close() {
        this.db.close();
        this.readerHandle.close();
        this.writerHandle.close();
    }

    public long getQueueSize() {
        return this.db.getSize();
    }
}

