/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.chain;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapUtil;
import cn.hutool.log.Log;
import cn.sanenen.chain.IMsgChain;
import cn.sanenen.chain.IMsgHandler;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.Chain;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ChainBase;
import org.apache.commons.chain.impl.ContextBase;

public class SimpleMsgChain<T>
implements IMsgChain<T> {
    private static final Log log = Log.get();
    private final Chain chain = new ChainBase();

    @Override
    public void setHandlers(List<IMsgHandler<T>> iMsgHandlers) {
        for (IMsgHandler<T> handler : iMsgHandlers) {
            this.chain.addCommand(new SimpleCommand<T>(handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(T t) {
        ContextBase contextBase = new ContextBase();
        contextBase.put((Object)"DATA", t);
        try {
            this.chain.execute((Context)contextBase);
        }
        catch (Exception e) {
            log.error((Throwable)e, "chain execute error. data:{}", new Object[]{JSON.toJSONString(t)});
        }
        finally {
            contextBase.clear();
        }
    }

    private static class SimpleCommand<T>
    extends TypeReference<T>
    implements Command {
        private final IMsgHandler<T> handler;

        public SimpleCommand(IMsgHandler<T> handler) {
            this.handler = handler;
        }

        public boolean execute(Context context) {
            return this.handler.process(MapUtil.get((Map)context, (Object)"DATA", (TypeReference)this));
        }
    }
}

