/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.db;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DbUtil {
    private static boolean useMybatisPlusAnnotation = false;

    public static <T> Entity toEntity(T obj, boolean ignoreNullValue) {
        Class clazz = ClassUtil.getClass(obj);
        if (clazz == null) {
            return null;
        }
        String tableName = DbUtil.getTableName(clazz);
        Entity entity = Entity.create((String)tableName);
        Collection props = BeanUtil.getBeanDesc((Class)clazz).getProps();
        for (PropDesc prop : props) {
            String key;
            Object value;
            Method getter = prop.getGetter();
            if (getter == null) continue;
            try {
                value = getter.invoke(obj, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (value == null && ignoreNullValue) continue;
            if (useMybatisPlusAnnotation) {
                TableField tableField = prop.getField().getAnnotation(TableField.class);
                if (tableField != null) {
                    if (!tableField.exist()) continue;
                    key = StrUtil.blankToDefault((CharSequence)tableField.value(), (String)StrUtil.toUnderlineCase((CharSequence)prop.getFieldName()));
                } else {
                    key = StrUtil.toUnderlineCase((CharSequence)prop.getFieldName());
                }
            } else {
                key = StrUtil.toUnderlineCase((CharSequence)prop.getFieldName());
            }
            entity.set(key, value);
        }
        return entity;
    }

    public static <T> Entity toEntity(T obj) {
        return DbUtil.toEntity(obj, true);
    }

    public static <T> List<Entity> toEntity(Collection<T> objs) {
        if (CollUtil.isEmpty(objs)) {
            return null;
        }
        return objs.stream().map(DbUtil::toEntity).collect(Collectors.toList());
    }

    public static <T> List<Entity> toEntity(Collection<T> objs, boolean ignoreNullValue) {
        if (CollUtil.isEmpty(objs)) {
            return null;
        }
        return objs.stream().map(o -> DbUtil.toEntity(o, ignoreNullValue)).collect(Collectors.toList());
    }

    public static <T> String getTableName(Class<T> clazz) {
        TableName tableNameA;
        String tableName = null;
        if (useMybatisPlusAnnotation && (tableNameA = clazz.getAnnotation(TableName.class)) != null) {
            tableName = tableNameA.value();
        }
        if (tableName == null) {
            tableName = StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName());
        }
        return tableName;
    }

    public static <T> Entity getIdEntity(T obj) {
        Class clazz = ClassUtil.getClass(obj);
        if (clazz == null) {
            return null;
        }
        if (!useMybatisPlusAnnotation) {
            return null;
        }
        String tableName = DbUtil.getTableName(clazz);
        Collection props = BeanUtil.getBeanDesc((Class)clazz).getProps();
        for (PropDesc prop : props) {
            TableId tableField;
            Object value;
            Method getter = prop.getGetter();
            if (getter == null) continue;
            try {
                value = getter.invoke(obj, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (value == null || (tableField = prop.getField().getAnnotation(TableId.class)) == null) continue;
            String key = StrUtil.blankToDefault((CharSequence)tableField.value(), (String)StrUtil.toUnderlineCase((CharSequence)prop.getFieldName()));
            Entity entity = Entity.create((String)tableName);
            entity.set(key, value);
            return entity;
        }
        return null;
    }

    static {
        try {
            Class<TableField> tableFieldClass = TableField.class;
            useMybatisPlusAnnotation = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

