/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.utils.sms.template.entity;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.sanenen.utils.sms.template.entity.TemplateResult;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateInfo {
    private static final Log log = Log.get();
    private Long id;
    private String content;
    @JSONField(deserialize=false)
    private String[] paramNames;
    @JSONField(deserialize=false)
    private String[] contents;

    public TemplateInfo(String content) {
        this.setContent(content);
    }

    public void setContent(String content) {
        this.content = content;
        try {
            String reg = "\\{\\{.*?}}";
            Pattern compile = Pattern.compile(reg);
            Matcher matcher = compile.matcher(content);
            ArrayList<String> paramList = new ArrayList<String>();
            while (matcher.find()) {
                String group = matcher.group();
                paramList.add(StrUtil.strip((CharSequence)group, (CharSequence)"{{", (CharSequence)"}}"));
            }
            this.paramNames = (String[])ArrayUtil.toArray(paramList, String.class);
            this.contents = content.split(reg, -1);
        }
        catch (Exception e) {
            log.error((Throwable)e, "set template content error", new Object[0]);
            this.content = null;
        }
    }

    public TemplateResult matchIn(String msg) {
        if (StrUtil.isBlank((CharSequence)msg) || StrUtil.isBlank((CharSequence)this.content)) {
            return null;
        }
        TemplateResult templateResult = new TemplateResult();
        int index = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            if (StrUtil.isBlank((CharSequence)this.contents[i])) {
                if (i != this.contents.length - 1) continue;
                templateResult.putParam(this.paramNames[i - 1], msg.substring(index));
                continue;
            }
            int s = msg.indexOf(this.contents[i], index);
            if (i == 0) {
                if (s != 0) {
                    index = -1;
                    break;
                }
                index = this.contents[i].length();
                continue;
            }
            if (i == this.contents.length - 1 && msg.length() - s != this.contents[i].length()) {
                index = -1;
                break;
            }
            if (s >= 0) {
                templateResult.putParam(this.paramNames[i - 1], msg.substring(index, s));
                index = s + this.contents[i].length();
                continue;
            }
            index = -1;
            break;
        }
        if (index == -1) {
            return null;
        }
        return templateResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateInfo that = (TemplateInfo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public String[] getContents() {
        return this.contents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return "TemplateInfo(id=" + this.getId() + ", content=" + this.getContent() + ", paramNames=" + Arrays.deepToString(this.getParamNames()) + ", contents=" + Arrays.deepToString(this.getContents()) + ")";
    }
}

