/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.utils.sms.phonegeo;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.sanenen.utils.sms.phonegeo.PhoneNumberInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class PhoneNumberGeo {
    private static final Log log = Log.get();
    private static final int INDEX_SEGMENT_LENGTH = 9;
    private static final String PHONE_DAT_FILE_PATH = "phone-number-geo/phone.dat";
    private static byte[] dataByteArray;
    private static int indexAreaOffset;
    private static int phoneRecordCount;
    private static ByteBuffer BYTE_BUFFER;

    private PhoneNumberGeo() {
    }

    private static synchronized void initData() {
        if (dataByteArray == null) {
            dataByteArray = FileUtil.readBytes((String)PHONE_DAT_FILE_PATH);
            BYTE_BUFFER = ByteBuffer.wrap(dataByteArray).asReadOnlyBuffer().order(ByteOrder.BIG_ENDIAN);
            byte[] version = new byte[4];
            BYTE_BUFFER.get(version);
            log.info("\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u6570\u636e\u7248\u672c\uff1a{}", new Object[]{new String(version)});
            indexAreaOffset = BYTE_BUFFER.getInt();
            phoneRecordCount = (dataByteArray.length - indexAreaOffset) / 9;
            log.info("\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u6570\u636e\u6570\u91cf\uff1a{}", new Object[]{phoneRecordCount});
        }
    }

    public static PhoneNumberInfo lookup(String phoneNumber) {
        int phoneNumberPrefix;
        ByteBuffer byteBuffer = BYTE_BUFFER.asReadOnlyBuffer().order(ByteOrder.BIG_ENDIAN);
        if (phoneNumber == null || phoneNumber.length() > 11 || phoneNumber.length() < 7) {
            return null;
        }
        try {
            phoneNumberPrefix = Integer.parseInt(phoneNumber.substring(0, 7));
        }
        catch (Exception e) {
            return null;
        }
        int left = 0;
        int right = phoneRecordCount;
        while (left <= right) {
            int middle = left + right >> 1;
            int currentOffset = indexAreaOffset + middle * 9;
            if (currentOffset >= dataByteArray.length) {
                return null;
            }
            byteBuffer.position(currentOffset);
            int currentPrefix = byteBuffer.getInt();
            if (currentPrefix > phoneNumberPrefix) {
                right = middle - 1;
                continue;
            }
            if (currentPrefix < phoneNumberPrefix) {
                left = middle + 1;
                continue;
            }
            int infoBeginOffset = byteBuffer.getInt();
            byte phoneType = byteBuffer.get();
            int infoLength = -1;
            for (int i = infoBeginOffset; i < indexAreaOffset; ++i) {
                if (dataByteArray[i] != 0) continue;
                infoLength = i - infoBeginOffset;
                break;
            }
            String infoString = new String(dataByteArray, infoBeginOffset, infoLength, StandardCharsets.UTF_8);
            String[] infoSegments = StrUtil.splitToArray((CharSequence)infoString, (CharSequence)"|");
            PhoneNumberInfo phoneNumberInfo = new PhoneNumberInfo();
            phoneNumberInfo.setPhoneNumber(phoneNumber);
            phoneNumberInfo.setProvince(infoSegments[0]);
            phoneNumberInfo.setCity(infoSegments[1]);
            phoneNumberInfo.setZipCode(infoSegments[2]);
            phoneNumberInfo.setAreaCode(infoSegments[3]);
            phoneNumberInfo.setCityCode(infoSegments[4]);
            phoneNumberInfo.setPhoneType(phoneType + "");
            return phoneNumberInfo;
        }
        return null;
    }

    static {
        PhoneNumberGeo.initData();
    }
}

