/*
 * Decompiled with CFR 0.152.
 */
package cn.sanenen.thread;

import cn.hutool.log.Log;

public abstract class StandardThread
implements Runnable {
    protected final Log log = Log.get(this.getClass());
    private boolean runFlag = true;

    @Override
    public void run() {
        while (this.runFlag) {
            this.handler();
        }
    }

    public void init() {
        this.initBefore();
        Thread thread = new Thread(this);
        thread.start();
        this.initAfter();
        this.log.info("{} init", new Object[]{this.getClass().getSimpleName()});
    }

    public void close() {
        this.closeBefore();
        this.runFlag = false;
        this.closeAfter();
        this.log.info("{} close", new Object[]{this.getClass().getSimpleName()});
    }

    protected abstract void handler();

    protected void initBefore() {
    }

    protected void initAfter() {
    }

    protected void closeBefore() {
    }

    protected void closeAfter() {
    }
}

