package cn.samehope.jcart.core.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

import cn.samehope.jcart.core.plugin.Mf;

/**
 * 
 * @author LD
 *
 */
public class ManifestUtil {
 
    /**
     *  
     * @param file
     * @return
     */
    public static final Mf manifestKey(File file) { 
        JarFile jar = null; 
        Mf plugin = null;
        try { 
            jar = new JarFile(file); 
            
            Manifest manifest = jar.getManifest();
            if(null != manifest){
            	Attributes attr = manifest.getMainAttributes();
            	attr.getValue("abc");
            	plugin = new Mf(attr.getValue("jarName")
            						,attr.getValue("jarDesc")
        							,attr.getValue("pluginClass")
									,""
								);
            }
            jar.close();
            return plugin;
            
        } catch (Exception e) { 
            throw new RuntimeException("Cannot read MANIFEST.MF from jar '" + file.getAbsolutePath() + "'.", e); 
        } finally { 
            if (jar != null) { 
                try { 
                    jar.close(); 
                } catch (IOException ioe) { 
                    throw new RuntimeException("Failed to close jar '" + file.getAbsolutePath() + "'.", ioe); 
                } 
            } 
        }
    } 
}
