package cn.samehope.jcart.core.render;

import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import cn.samehope.jcart.core.handler.action.ActionCacheManager;

import com.jfinal.kit.PropKit;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import com.jfinal.render.TemplateRender;

/**
 * 渲染模板时，不同的配置使用不同的模板文件；并可将渲染的页面对象保存到缓存中
 * @author Administrator
 *
 */
public class MyRender extends TemplateRender{

	public MyRender(String view) {
		super(view);
		// TODO Auto-generated constructor stub
	}
	
	public void render() {
		response.setContentType(getContentType());
        
		Map<Object, Object> data = new HashMap<Object, Object>();
		for (Enumeration<String> attrs=request.getAttributeNames(); attrs.hasMoreElements();) {
			String attrName = attrs.nextElement();
			data.put(attrName, request.getAttribute(attrName));
		}
		
		//如果是前端模板, 读取相关配置文件的模板名称
		if(!view.startsWith("/_admin")){
			view = "/_template" + PropKit.get("templateName") + view;
		}
		
        try {
        	Writer writer = response.getWriter();
        	//判断是否需要缓存页面数据
        	if (!ActionCacheManager.isCloseActionCache() && ActionCacheManager.isEnableCache(request)) {
    			String htmlContent = RenderManager.me().getEngine().getTemplate(view).renderToString(data);
    			ActionCacheManager.putCache(request, htmlContent);
    		}
        	RenderManager.me().getEngine().getTemplate(view).render(data, writer);
        	writer.flush();
		} catch (Exception e) {
			throw new RenderException(e);
		}
	}

}
