package cn.samehope.jcart.core.menu;

import java.util.ArrayList;
import java.util.List;

import com.jfinal.json.FastJson;
import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.ehcache.CacheKit;

import cn.samehope.jcart.core.util.LogUtil;
import cn.samehope.jcart.core.util.StringUtil;
import cn.samehope.jcart.core.util.TreeUtils;

/**
 * 菜单工具类
 * @author LD
 *
 */
public class MenuKit {
	
	public static final String CACHE_BINARY_TREE = "BINARY_TREE";
	public static final String KEY_BINARY_TREE_NODE = "KEY_BINARY_TREE_NODE";
	public static final String KEY_BINARY_TREE_LIST = "KEY_BINARY_TREE_LIST";
	
	/**
	 * 添加菜单到菜单树
	 * @param Menu
	 */
	public static void put(Menu e){
		if(null == e){
			LogUtil.error("节点不可为空");
			return;
		}
		if(StringUtil.isBlank(e.getId())){
			LogUtil.error("节点ID不可为空"  + JsonKit.toJson(e));
			return;
		}
		if(StringUtil.isBlank(e.getPid())){
			LogUtil.error("父节点ID不可为空" + JsonKit.toJson(e));
			return;
		}
		List<Menu> nodeList = CacheKit.get(CACHE_BINARY_TREE, KEY_BINARY_TREE_LIST);
		if(null == nodeList){
			nodeList = new ArrayList<Menu>();
			nodeList.add(new Menu("0", "", "",""));
		}
		for(Menu x: nodeList){
			if(x.getId().equals(e.getId())){
				LogUtil.error("此节点已存在" + JsonKit.toJson(x));
				return;
			}
		}
		nodeList.add(e);
		//生成二叉树信息
		Menu node = addNode(nodeList);
		CacheKit.put(CACHE_BINARY_TREE, KEY_BINARY_TREE_LIST, nodeList);
		CacheKit.put(CACHE_BINARY_TREE, KEY_BINARY_TREE_NODE, node);
		
		LogUtil.info(JsonKit.toJson(node));
		LogUtil.info(JsonKit.toJson(nodeList));
	}
	
	/**
	 * 获取相关节点下的 所有节点信息
	 * @param id
	 * @return 
	 */
	public static Menu getKeys(String id){
		List<Menu> nodeList = CacheKit.get(CACHE_BINARY_TREE, KEY_BINARY_TREE_LIST);
		for(Menu e: nodeList){
			if(e.getId().equals(id)){
				LogUtil.info(JsonKit.toJson(e));
				return e;
			}
		}
		return null;
	}
	
	/**
	 * 添加节点信息，生成树
	 * @param list
	 * @return
	 */
	private static Menu addNode(List<Menu> list){
		Menu node = new Menu("0", "", "","");
		TreeUtils.createTree(list, node, "id", "pid", "nodes");
		return node;
	}

}
