package cn.samehope.jcart.core.menu;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单实体类
 * @author LD
 *
 */
public class Menu implements Serializable {
	
	private static final long serialVersionUID = 1L;

	//菜单唯一标识
	private String id;
	
	//菜单名称
	private String name;
	
	//路由地址
	private String url;
	
	//上级菜单
	private String pid;
	
	//下级菜单集合
	private List<Menu> nodes;
	
	/**
	 * 构造方法
	 * @param id唯一标识
	 * @param name名称
	 * @param url路由地址
	 * @param pid上级菜单
	 */
	public Menu(String id, String name, String url, String pid){
		this.id = id;
		this.name = name;
		this.url = url;
		this.pid = pid;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getPid() {
		return pid;
	}

	public void setPid(String pid) {
		this.pid = pid;
	}

	public List<Menu> getNodes() {
		return nodes;
	}

	public void setNodes(List<Menu> nodes) {
		this.nodes = nodes;
	}

}
