package cn.samehope.jcart.core.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.samehope.jcart.core.SysConsts;

import com.jfinal.handler.Handler;
import com.jfinal.kit.PropKit;

/**
 * 参数设置
 * @author Administrator
 *
 */
public class SysHandler extends Handler{

	@Override
	public void handle(String target, HttpServletRequest request,
			HttpServletResponse response, boolean[] isHandled) {
		// TODO Auto-generated method stub
		String CPATH = request.getContextPath();
		request.setAttribute("REQUEST", request);
		//项目名称
		request.setAttribute("CPATH", CPATH);
		//后台路径
		request.setAttribute("ADMIN_PATH", CPATH + "/_admin");
		//前端模板路径
		request.setAttribute("TEMPLATE_PATH", CPATH + "/_template" + PropKit.use("jcart.properties").get("templateName"));
		
		request.setAttribute(SysConsts.ATTR_GLOBAL_WEB_NAME, PropKit.use("jcart.properties").get("webName",""));
		request.setAttribute(SysConsts.ATTR_GLOBAL_WEB_TITLE, PropKit.use("jcart.properties").get("webTitle",""));
		request.setAttribute(SysConsts.ATTR_GLOBAL_WEB_SUBTITLE, PropKit.use("jcart.properties").get("webSubtitle",""));
		request.setAttribute(SysConsts.ATTR_GLOBAL_META_KEYWORDS, PropKit.use("jcart.properties").get("metaKeywords",""));
		request.setAttribute(SysConsts.ATTR_GLOBAL_META_DESCRIPTION, PropKit.use("jcart.properties").get("metaDescription",""));
		
		request.setAttribute("TPATH", "");
		request.setAttribute("CTPATH", request.getContextPath());
		
		next.handle(target, request, response, isHandled);
	}

}
