package cn.samehope.jcart.core.handler;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.samehope.jcart.core.handler.action.ActionCacheManager;
import cn.samehope.jcart.core.handler.action.ActionCacheMapper;

import com.jfinal.core.Action;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;

/**
 * ACTION缓存处理
 * @author Ld
 *
 */
public class ActionCacheHandler extends Handler{
	
	static String[] urlPara = { null };

	@Override
	public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {

		//判断是否开启ACTION缓存设置
		if (ActionCacheManager.isCloseActionCache()) {
			next.handle(target, request, response, isHandled);
			return;
		}

		//获取当前ACTION对象
		Action action = JFinal.me().getAction(target, urlPara);
		if (action == null) {
			next.handle(target, request, response, isHandled);
			return;
		}

		//判断ACTION是否使用了ACTION缓存的注解
		ActionCacheMapper actionCacheMapper = action.getMethod().getAnnotation(ActionCacheMapper.class);
		if (actionCacheMapper == null) {
			actionCacheMapper = action.getControllerClass().getAnnotation(ActionCacheMapper.class);
			if (actionCacheMapper == null) {
				next.handle(target, request, response, isHandled);
				return;
			}
		}

		String cacheKey = target;

		//参数
		String queryString = request.getQueryString();
		if (queryString != null) {
			queryString = "?" + queryString;
			cacheKey += queryString;
		}

		//设置request 的属性
		ActionCacheManager.enableCache(request);
		ActionCacheManager.setCacheKey(request, cacheKey);
		ActionCacheManager.setCacheContentType(request, actionCacheMapper.contentType());

		String renderContent = ActionCacheManager.getCache(request, cacheKey);
		if (renderContent != null) {
			response.setContentType(actionCacheMapper.contentType());

			PrintWriter writer = null;
			try {
				writer = response.getWriter();
				writer.write(renderContent);
				isHandled[0] = true;
			} catch (Exception e) {

			} finally {
				if (writer != null) {
					writer.close();
				}
			}
		} else {
			next.handle(target, request, response, isHandled);
		}
	}
}
