package cn.samehope.jcart.core;

import java.io.File;
import java.sql.Connection;
import java.util.List;

import cn.samehope.jcart.core.handler.ActionCacheHandler;
import cn.samehope.jcart.core.handler.SysHandler;
import cn.samehope.jcart.core.plugin.JCartPluginKit;
import cn.samehope.jcart.core.render.MyRenderFactory;
import cn.samehope.jcart.core.route.RouteClassKit;
import cn.samehope.jcart.core.route.RouteAuthKit;
import cn.samehope.jcart.core.route.RouterMapping;
import cn.samehope.jcart.core.util.DruidUtil;
import cn.samehope.jcart.core.util.StringUtil;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.wall.WallFilter;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.ext.handler.ContextPathHandler;
import com.jfinal.json.MixedJsonFactory;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.cron4j.Cron4jPlugin;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.plugin.ehcache.EhCachePlugin;
import com.jfinal.template.Engine;

/**
 * core包启动类
 * @author LD
 *
 */
public abstract class JCartConfig extends JFinalConfig {
	
	/**
	 * 启动入口，运行此 main 方法可以启动项目，此main方法可以放置在任意的Class类定义中，不一定要放于此
	 * 
	 * 使用本方法启动过第一次以后，会在开发工具的 debug、run configuration 中自动生成
	 * 一条启动配置项，可对该自动生成的配置再继续添加更多的配置项，例如 VM argument 可配置为：
	 * -XX:PermSize=64M -XX:MaxPermSize=256M
	 * 上述 VM 配置可以缓解热加载功能出现的异常
	 */
	public static void main(String[] args) {
		/**
		 * 特别注意：Eclipse 之下建议的启动方式
		 */
		JFinal.start("src/main/webapp", 80, "/", 5);
		
		/**
		 * 特别注意：IDEA 之下建议的启动方式，仅比 eclipse 之下少了最后一个参数
		 */
		// JFinal.start("src/main/webapp", 80, "/");
	}
	
	/**
	 * 配置基本常量
	 */
    public void configConstant(Constants me) {
        me.setDevMode(PropKit.use("jcart.properties").getBoolean("devMode", false));
		me.setJsonFactory(MixedJsonFactory.me()); 
		me.setRenderFactory(new MyRenderFactory());//处理渲染时，将需要保存的页面缓存放到EHCACHE中。
		
		configAppConstant( me);
    }
    
    /**
     * 路由拆分到 FrontRutes 与 AdminRoutes 之中配置的好处：
     * 1：可分别配置不同的 baseViewPath 与 Interceptor
     * 2：避免多人协同开发时，频繁修改此文件带来的版本冲突
     * 3：避免本文件中内容过多，拆分后可读性增强
     * 4：便于分模块管理路由
     */
    @SuppressWarnings("unchecked")
	public void configRoute(Routes me) {
    	//me.add("/", BlogController.class, "/_admin/blog");
    	//me.add(new AdminRoutes());
    	
    	List<Class<Controller>> controllerClassList = RouteClassKit.scanSubClass(Controller.class, PathKit.getWebRootPath()+"/WEB-INF", "jcart");
		if (controllerClassList != null) {
			for (Class<?> clazz : controllerClassList) {
				RouterMapping urlMapping = clazz.getAnnotation(RouterMapping.class);
				if (null != urlMapping && StringUtil.isNotBlank(urlMapping.url())) {
					if (StrKit.notBlank(urlMapping.viewPath())) {
						me.add(urlMapping.url(), (Class<? extends Controller>) clazz, urlMapping.viewPath());
					} else {
						me.add(urlMapping.url(), (Class<? extends Controller>) clazz);
					}
					RouteAuthKit.addMethodAuth(urlMapping, clazz);
				}
			}
		}
    }
    
    /**
     * 配置模板引擎，通常情况只需配置共享的模板函数
     */
    public void configEngine(Engine me) {
    	
    	configAppEngine( me);
    }
	
	/**
	 * 项目启动 加载项目插件
	 */
    public void configPlugin(Plugins me) {
//	    DruidPlugin druidPlugin = getDruidPlugin();
//	    wallFilter = new WallFilter();              // 加强数据库安全
//	    wallFilter.setDbType("mysql");
//	    druidPlugin.addFilter(wallFilter);
//	    druidPlugin.addFilter(new StatFilter());    // 添加 StatFilter 才会有统计数据
//	    me.add(druidPlugin);
//	    
//	    ActiveRecordPlugin arp = new ActiveRecordPlugin(druidPlugin);
//	    arp.setTransactionLevel(Connection.TRANSACTION_READ_COMMITTED);
//	    _MappingKit.mapping(arp);
//	    // 强制指定复合主键的次序，避免不同的开发环境生成在 _MappingKit 中的复合主键次序不相同
//	    //arp.setPrimaryKey("document", "mainMenu,subMenu");
//	    me.add(arp);
//        if (p.getBoolean("devMode", false)) {
//            arp.setShowSql(true);
//        }
//        arp.setBaseSqlTemplatePath(PathKit.getWebRootPath() + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "sql");
//        //arp.setBaseSqlTemplatePath(PathKit.getRootClassPath() + "/sql");
//        arp.addSqlTemplate("all_sqls.sql");
        
        //缓存
	    me.add(new EhCachePlugin());
	    //定时任务
	    me.add(new Cron4jPlugin(PropKit.use("task.properties")));
	    
	    configAppPlugin( me);
    }
    
    /**
     * 配置全局拦截器
     */
    public void configInterceptor(Interceptors me) {
    	
    	configAppInterceptor( me);
    }
    
    /**
     * 配置处理器
     */
    public void configHandler(Handlers me) {
    	me.add(new ContextPathHandler("CTX_PATH"));
    	me.add(new SysHandler());   					//页面参数
    	me.add(new ActionCacheHandler());   			//是否读取页面缓存数据
	    me.add(DruidUtil.getDruidStatViewHandler()); 	// druid 统计页面功能
	    
	    configAppHandler( me);
    }
    
    /**
     * 本方法会在 jfinal 启动过程完成之后被回调，详见 jfinal 手册
     */
	public void afterJFinalStart() {
		//加载钩子
		//HookKit.loadSysHook();
		// 让 druid 允许在 sql 中使用 union
		JCartPluginKit.startJCartPlugins();
		
		loadAppStart();
		loadAppMenu();
		loadAppHook();
		loadAppPlugin();
	}
	
	/**
	 * 扩展APP JFINAL系统常量
	 * @param me
	 */
	public abstract void configAppConstant(Constants me);
	
	/**
	 * 扩展APP JFINAL模板
	 * @param me
	 */
	public abstract void configAppEngine(Engine me);
		
	/**
	 * 扩展APP JFINAL插件
	 * @param me
	 */
	public abstract void configAppPlugin(Plugins me);
	
	/**
	 * 扩展APP拦截器
	 * @param me
	 */
	public abstract void configAppInterceptor(Interceptors me);
	
	/**
	 * 扩展APP处理器
	 * @param me
	 */
	public abstract void configAppHandler(Handlers me);
	
	/**
	 * 系统加载后，app需要启动的内容
	 */
	public abstract void loadAppStart();
	
	/**
	 * 系统加载后，app需要加载的菜单
	 */
	public abstract void loadAppMenu();
	
	/**
	 * 系统加载后，app需要加载的HOOK
	 */
	public abstract void loadAppHook();
	
	/**
	 * 系统加载后，app需要APP插件
	 */
	public abstract void loadAppPlugin();
	
}
