package cn.samehope.jcart.core;

import javax.servlet.http.HttpSession;

import cn.samehope.jcart.core.util.RequestUtil;

import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.i18n.Res;

/**
 * Controller子类 提供
 * 提供一些基础工具
 * @author Administrator
 *
 */
public class BaseController extends Controller {
	private static final char URL_PARA_SEPARATOR = JFinal.me().getConstants().getUrlParaSeparator().toCharArray()[0];
	private JSession session;

	public BaseController() {
		session = new JSession(this);
	}

//	@Override
//	public String getPara(String name) {
//		return JsoupUtils.clear(getRequest().getParameter(name));
//	}
//
//	@Override
//	public String getPara(String name, String defaultValue) {
//		String html = getRequest().getParameter(name);
//		if (null != html) {
//			return JsoupUtils.clear(html);
//		}
//		return defaultValue;
//	}

	private int mParaCount = -1;

	public int getParaCount() {
		if (mParaCount != -1)
			return mParaCount;

		mParaCount = 0;
		char[] parachars = getPara() == null ? null : getPara().toCharArray();
		if (parachars != null) {
			mParaCount = 1;
			for (char c : parachars) {
				if (URL_PARA_SEPARATOR == c) {
					mParaCount++;
				}
			}
		}
		return mParaCount;
	}

	/**
	 * 是否是手机浏览器
	 * 
	 * @return
	 */
	public boolean isMoblieBrowser() {
		return RequestUtil.isMoblieBrowser(getRequest());
	}

	/**
	 * 是否是微信浏览器
	 * 
	 * @return
	 */
	public boolean isWechatBrowser() {
		return RequestUtil.isWechatBrowser(getRequest());
	}

	/**
	 * 是否是IE浏览器
	 * 
	 * @return
	 */
	public boolean isIEBrowser() {
		return RequestUtil.isIEBrowser(getRequest());
	}

	public boolean isAjaxRequest() {
		return RequestUtil.isAjaxRequest(getRequest());
	}

	public boolean isMultipartRequest() {
		return RequestUtil.isMultipartRequest(getRequest());
	}

	protected int getPageNumber() {
		int page = getParaToInt("page", 1);
		if (page < 1) {
			page = 1;
		}
		return page;
	}

	protected int getPageSize() {
		int size = getParaToInt("size", 10);
		if (size < 1) {
			size = 1;
		}
		return size;
	}

	public void setHeader(String key, String value) {
		getResponse().setHeader(key, value);
	}

	public Res getI18nRes() {
		// Attribute set in JI18nInterceptor.class
		return getAttr("i18n");
	}

	public String getI18nValue(String key) {
		return getI18nRes().get(key);
	}

	@Override
	public HttpSession getSession() {
		return session;
	}

	@Override
	public HttpSession getSession(boolean create) {
		return getSession();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getSessionAttr(String key) {
		return (T) session.getAttribute(key);
	}

	@Override
	public Controller setSessionAttr(String key, Object value) {
		session.setAttribute(key, value);
		return this;
	}

	@Override
	public Controller removeSessionAttr(String key) {
		session.removeAttribute(key);
		return this;
	}

	@Before(NotAction.class)
	public String getIPAddress() {
		return RequestUtil.getIpAddress(getRequest());
	}

}