package cn.samehope.jcart.core.route;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import cn.samehope.jcart.core.util.LogUtil;

/**
 * 路由权限工具类
 * @author LD
 *
 */
public class RouteAuthKit {
	
	//路由权限对应参数集合
	private static Map<String, String> routeMethodMap = new HashMap<String, String>();

	public static Map<String, String> getRouteMethodMap() {
		return routeMethodMap;
	}

	/**
	 * 添加对应的信息到集合中
	 * @param urlMapping
	 * @param clazz
	 */
	public static void addMethodAuth(RouterMapping urlMapping, Class<?> clazz){
		Method[] methods = clazz.getDeclaredMethods();
        for (Method m : methods) {
        	RouterAuth routerAuth = m.getAnnotation(RouterAuth.class);
            if (null != routerAuth) {
            	routeMethodMap.put(urlMapping.url() + "/" + m.getName(), urlMapping.name() + routerAuth.name());
            	LogUtil.info(urlMapping.url() + "/" + m.getName() + "-------" + urlMapping.name() + routerAuth.name());
            }
        }
	}

}
