package cn.samehope.jcart.core.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

import cn.samehope.jcart.core.util.LogUtil;
import cn.samehope.jcart.core.util.ManifestUtil;

import com.jfinal.kit.JsonKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.ehcache.CacheKit;

/**
 * 插件工具类
 * @author LD
 *
 */
public class JCartPluginKit {
	
	public static final String propFileName = "app.properties";
	
	public static final String PLUGINSTATUS_UNINSTALL = "unInstall";//未安装
	
	public static final String PLUGINSTATUS_INSTALL = "install";//未启用
	
	public static final String PLUGINSTATUS_USE = "use";//已启用
		
	private static List<IJCartPlugin> jCartPlugins = new ArrayList<IJCartPlugin>();
	
	/**
	 * 添加插件
	 * @param plugin
	 */
	public void add(IJCartPlugin plugin) {
		if (plugin == null) {
			throw new IllegalArgumentException("plugin can not be null");
		}
		jCartPlugins.add(plugin);
	}
	
	/**
	 * 上传JAR包后调用此方法
	 * @param file
	 */
	public void add(File file){
		Mf mf = getJarProperty(file);
		mf.setStatus(PLUGINSTATUS_UNINSTALL);
		writeProperties(mf.getJarName(), JsonKit.toJson(mf));
		CacheKit.put("", mf.getJarName(), JsonKit.toJson(mf));
	}
	
	/**
	 * 写入配置文件
	 * @param key
	 * @param value
	 */
	public static void writeProperties (String key, String value) {
		Prop p = PropKit.use(propFileName);
		p.getProperties().setProperty(key, value);
	}
	
	/**
	 * 读取JAR包中的配置文件信息
	 * @param file
	 * @return
	 */
	public static Mf getJarProperty(File file){
		return ManifestUtil.manifestKey(file);
	}

	/**
	 * 执行启动类
	 * 读取插件配置文件，启动相关插件
	 * @param <T>
	 */
	public static <T> void startJCartPlugins() {
		
		//读取配置文件信息
		Properties pluginProps = PropKit.use(propFileName).getProperties();
		if (pluginProps == null) {
			return ;
		}
		
		Enumeration<?> en = pluginProps.propertyNames();
		while(en.hasMoreElements()) {
			String strKey = (String) en.nextElement();
			String strValue = pluginProps.getProperty(strKey);
			LogUtil.info(strKey + "=" + strValue);
			Mf mf = JsonKit.parse(strValue, Mf.class);
			
			//当
			if(mf.getStatus().equals(PLUGINSTATUS_INSTALL) || mf.getStatus().equals(PLUGINSTATUS_USE)){
				try {
					Class<IJCartPlugin> clazz = classForName(mf.getPluginClass());
					IJCartPlugin plugin = clazz.newInstance();
					plugin.start();
				}catch (Exception e1) {
					LogUtil.error(e1.getMessage());
					e1.printStackTrace();
				} 
			}
		}
	}
	
	/**
	 * 执行卸载方法
	 * 读取插件配置文件，启动相关插件
	 * @param <T>
	 */
	public static void uninstallPlugins(Mf mf) {

		try {
			Class<IJCartPlugin> clazz = classForName(mf.getPluginClass());
			IJCartPlugin plugin = clazz.newInstance();
			plugin.unInstall();
			mf.setStatus(PLUGINSTATUS_UNINSTALL);
			writeProperties(mf.getJarName(), JsonKit.toJson(mf));
		}catch (Exception e1) {
			LogUtil.error(e1.getMessage());
			e1.printStackTrace();
		} 
	}
	
	/**
	 * 执行停止方法
	 * @param pe
	 */
	public static void stopPlugins(Mf mf) {

		try {
			Class<IJCartPlugin> clazz = classForName(mf.getPluginClass());
			IJCartPlugin plugin = clazz.newInstance();
			plugin.stop();
			mf.setStatus(PLUGINSTATUS_INSTALL);
			writeProperties(mf.getJarName(), JsonKit.toJson(mf));
		}catch (Exception e1) {
			LogUtil.error(e1.getMessage());
			e1.printStackTrace();
		} 
	}
	
	/**
	 * 执行安装方法
	 * @param pe
	 */
	public static void installPlugins(Mf pe) {

		try {
			Class<IJCartPlugin> clazz = classForName(pe.getPluginClass());
			IJCartPlugin plugin = clazz.newInstance();
			plugin.install();
			pe.setStatus(PLUGINSTATUS_INSTALL);
			writeProperties(pe.getJarName(), JsonKit.toJson(pe));
		}catch (Exception e1) {
			LogUtil.error(e1.getMessage());
			e1.printStackTrace();
		} 
	}
	
	@SuppressWarnings("unchecked")
	private static Class<IJCartPlugin> classForName(String className) {
		Class<IJCartPlugin> clazz = null;
		try {
			ClassLoader cl = Thread.currentThread().getContextClassLoader();
			clazz = (Class<IJCartPlugin>) Class.forName(className, false, cl);
		} catch (Throwable e) {
			LogUtil.error("classForName is error，className:" + className);
		}
		return clazz;
	}
}
