package cn.samehope.jcart.core.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.jfinal.plugin.ehcache.CacheKit;

import cn.samehope.jcart.core.SysConsts;
import cn.samehope.jcart.core.util.StringUtil;

/**
 * 钩子责任链工具类
 * @author LD
 *
 */
public class HookKit {
			
	/**
	 * 添加钩子责任链处理类
	 * @param 钩子类型          hookType
	 * @param 责任链处理类 hookHandler
	 * @return
	 */
	public static void add(String hookType, Hook hookHandler) {
		add(hookType, hookHandler, SysConsts.CACHE_GLOBAL_HOOK_NUM);
	}
	
	/**
	 * 添加钩子责任链处理类
	 * @param 钩子类型         hookType
	 * @param 责任链处理类 hookHandler
	 * @param 排序                   orderNo
	 */
	public static void add(String hookType, Hook hookHandler, int orderNo) {
		if (hookHandler == null) {
			throw new IllegalArgumentException("hookHandler can not be null");
		}
		if (StringUtil.isBlank(hookType)) {
			throw new IllegalArgumentException("hookType can not be null");
		}
		hookHandler.setOrderNo(orderNo);
		List<Hook> ls = CacheKit.get(SysConsts.CACHE_GLOBAL_HOOK, hookType);
		if(null == ls){
			ls = new ArrayList<Hook>();
		}
		ls.add(hookHandler);
		CacheKit.put(SysConsts.CACHE_GLOBAL_HOOK, hookType, ls);
		CacheKit.remove(SysConsts.CACHE_GLOBAL_HOOK_HANDLER, hookType);
	}
	
	/**
	 * 移除责任链处理类
	 * @param hookType
	 * @param hookHandler
	 */
	public static void remove(String hookType, Hook hookHandler){
		if (hookHandler == null) {
			throw new IllegalArgumentException("hookHandler can not be null");
		}
		if (StringUtil.isBlank(hookType)) {
			throw new IllegalArgumentException("hookType can not be null");
		}
		List<Hook> ls = CacheKit.get(SysConsts.CACHE_GLOBAL_HOOK, hookType);
		if(null != ls){
			ls.remove(hookHandler);
			CacheKit.put(SysConsts.CACHE_GLOBAL_HOOK, hookType, ls);
		}
		CacheKit.remove(SysConsts.CACHE_GLOBAL_HOOK_HANDLER, hookType);
	}
	
	/**
	 * 获取对应的钩子责任链
	 * @param hookType
	 * @return
	 */
	public static List<Hook> getHandlerList(String hookType) {
		return CacheKit.get(SysConsts.CACHE_GLOBAL_HOOK, hookType);
	}
	
	/**
	 * 获取对应的责任链初始类
	 * @param handlerList
	 * @param actionHandler
	 * @return
	 */
	public static Hook getHookHandler(String hookType) {
		Hook result = CacheKit.get(SysConsts.CACHE_GLOBAL_HOOK_HANDLER, hookType);
		//判断是否在缓存中存在此对象
		if(null == result){
			result = new BaseHook();
			List<Hook> ls = CacheKit.get(SysConsts.CACHE_GLOBAL_HOOK, hookType);
			//排序
			orderByNo(ls);
			for (int i= ls.size()-1; i>=0; i--) {
				Hook temp = ls.get(i);
				temp.next = result;
				result = temp;
			}
			CacheKit.put(SysConsts.CACHE_GLOBAL_HOOK_HANDLER, hookType, result);
		}
		return result;
	}
	
	/**
	 * 对list进行排序
	 * @param List<HookHandler>
	 */
	private static void orderByNo(List<Hook> ls) {  
		Collections.sort(ls, new Comparator<Hook>() {  
			  
			public int compare(Hook o1, Hook o2) {  	   
				if (o1.getOrderNo() == o2.getOrderNo())  return 0;  
				else  return o2.getOrderNo().compareTo(o1.getOrderNo()); 
			}  
		}); 
	}
	
	public static void main(String[] args) {   
        
//        HookKit.add("test", new Test1(), 2);
//        HookKit.add("test", new Test2());
//        
//        HookKit.getHookHandler("test").exec(1,2);
    } 

}
