/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.simple.web;

import cn.safekeeper.common.annotations.SafeKeeperHasPermission;
import cn.safekeeper.common.annotations.SafeKeeperHasRole;
import cn.safekeeper.core.SafeKeeper;
import cn.safekeeper.core.manager.SafeKeeperManager;
import cn.safekeeper.plugin.web.Result;
import cn.safekeeper.simple.web.vo.UserVO;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SimpleController {
    private static final String name = "admin";
    private static final String password = "admin";

    @RequestMapping(value={"/sayHello"})
    public String sayHello() {
        return "Dear developers, welcome to the SafeKeeper world!";
    }

    @RequestMapping(value={"/safeKeeper"})
    @SafeKeeperHasRole(roles={"user"})
    public String safeKeeper() {
        return "Dear developers, You should want to log in after access!";
    }

    @RequestMapping(value={"/clearData"})
    @SafeKeeperHasPermission(permissions={"user:usermanager:add"})
    public String clearData(@RequestBody UserVO user) {
        SafeKeeperManager.getSafeKeeperTokenRealm().clearRoleOrPermissionCacheData((Object)user.getId(), SafeKeeperManager.getConfig().getDefaultLoginType(), Integer.valueOf(0));
        return "clear role cache data successfully!";
    }

    @RequestMapping(value={"/xxx"})
    @SafeKeeperHasPermission(permissions={"user:usermanager:xxx"})
    public String xxx(@RequestBody UserVO user) {
        SafeKeeperManager.getSafeKeeperTokenRealm().clearRoleOrPermissionCacheData((Object)user.getId(), SafeKeeperManager.getConfig().getDefaultLoginType(), Integer.valueOf(1));
        return "clear permission cache data successfully!";
    }

    @RequestMapping(value={"/clearPer"})
    @SafeKeeperHasPermission(permissions={"order:usermanager:save"})
    public String clearPer(@RequestBody UserVO user) {
        SafeKeeperManager.getSafeKeeperTokenRealm().clearRoleOrPermissionCacheData((Object)user.getId(), SafeKeeperManager.getConfig().getDefaultLoginType(), Integer.valueOf(1));
        return "clear permission cache data successfully!";
    }

    @RequestMapping(value={"/delUser"})
    @SafeKeeperHasRole(roles={"admin"})
    public String delUser() {
        return "Dear developers, You should want to log in after access!";
    }

    @RequestMapping(value={"/login"})
    public Result login(@RequestBody UserVO user, HttpServletRequest request) {
        if (!StringUtils.isEmpty((Object)user) && user.getUsername().equals("admin") && user.getPassword().equals("admin")) {
            if (request.getHeader("loginType") == null) {
                if (user.getDevice() != null) {
                    SafeKeeper.safeDefault().login((Object)user.getId(), user.getDevice());
                } else {
                    SafeKeeper.safeDefault().login((Object)user.getId());
                }
                return Result.failedWith((Object)SafeKeeper.safeDefault().getSafeKeeperInfo(), (Integer)1001, (String)"\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
            }
            if (user.getDevice() != null) {
                SafeKeeper.safeLogic((String)request.getHeader("loginType")).login((Object)user.getId(), user.getDevice());
            } else {
                SafeKeeper.safeLogic((String)request.getHeader("loginType")).login((Object)user.getId());
            }
        }
        return Result.failedWith(null, (Integer)1001, (String)"\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
    }
}

