/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.session;

import cn.safekeeper.common.function.SafeKeeperFunction;
import cn.safekeeper.common.utils.SafeKeeperUtils;
import cn.safekeeper.core.manager.SafeKeeperManager;
import cn.safekeeper.core.session.SafeKeeperToken;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SafeKeeperSession
implements Serializable {
    private String id;
    private long createTime;
    private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private final List<SafeKeeperToken> tokenList = new CopyOnWriteArrayList<SafeKeeperToken>();

    public SafeKeeperSession() {
    }

    public SafeKeeperSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
        SafeKeeperManager.getSafeKeeperTokenListener().doCreateSession(id);
    }

    public SafeKeeperToken getTokenSign(String tokenValue) {
        for (SafeKeeperToken safeKeeperToken : this.getTokenList()) {
            if (!safeKeeperToken.getValue().equals(tokenValue)) continue;
            return safeKeeperToken;
        }
        return null;
    }

    public void addTokenSign(SafeKeeperToken safeKeeperToken) {
        for (SafeKeeperToken safeKeeperToken2 : this.getTokenList()) {
            if (!safeKeeperToken2.getValue().equals(safeKeeperToken.getValue())) continue;
            return;
        }
        this.getTokenList().add(safeKeeperToken);
        this.update();
    }

    public void removeTokenSign(String tokenValue) {
        SafeKeeperToken safeKeeperToken = this.getTokenSign(tokenValue);
        if (this.getTokenList().remove(safeKeeperToken)) {
            this.update();
        }
    }

    public void update() {
        SafeKeeperManager.getSafeKeeperTokenRealm().updateSession(this);
    }

    public void logout() {
        SafeKeeperManager.getSafeKeeperTokenRealm().deleteSession(this.id);
        SafeKeeperManager.getSafeKeeperTokenListener().doLogoutSession(this.id);
    }

    public long getTimeout() {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getSessionTimeout(this.id);
    }

    public void updateTimeout(long timeout) {
        SafeKeeperManager.getSafeKeeperTokenRealm().updateSessionTimeout(this.id, timeout);
    }

    public void updateMinTimeout(long minTimeout) {
        if (this.getTimeout() < minTimeout) {
            SafeKeeperManager.getSafeKeeperTokenRealm().updateSessionTimeout(this.id, minTimeout);
        }
    }

    public void updateMaxTimeout(long maxTimeout) {
        if (this.getTimeout() > maxTimeout) {
            SafeKeeperManager.getSafeKeeperTokenRealm().updateSessionTimeout(this.id, maxTimeout);
        }
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        return this.getValueByDefaultValue(this.get(key), defaultValue);
    }

    public <T> T get(String key, SafeKeeperFunction fun) {
        Object value = this.get(key);
        if (value == null) {
            this.set(key, value);
        }
        return (T)value;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public int getInt(String key) {
        return this.getValueByDefaultValue(this.get(key), 0);
    }

    public long getLong(String key) {
        return this.getValueByDefaultValue(this.get(key), 0L);
    }

    public double getDouble(String key) {
        return this.getValueByDefaultValue(this.get(key), 0.0);
    }

    public float getFloat(String key) {
        return this.getValueByDefaultValue(this.get(key), Float.valueOf(0.0f)).floatValue();
    }

    public <T> T getModel(String key, Class<T> cs) {
        return (T)SafeKeeperUtils.getValueByType((Object)this.get(key), cs);
    }

    public <T> T getModel(String key, Class<T> cs, Object defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return (T)defaultValue;
        }
        return (T)SafeKeeperUtils.getValueByType((Object)value, cs);
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    public SafeKeeperSession set(String key, Object value) {
        this.data.put(key, value);
        this.update();
        return this;
    }

    public SafeKeeperSession setDefaultValue(String key, Object value) {
        if (!this.has(key)) {
            this.data.put(key, value);
            this.update();
        }
        return this;
    }

    public boolean has(String key) {
        return !this.valueIsNull(this.get(key));
    }

    public SafeKeeperSession delete(String key) {
        this.data.remove(key);
        this.update();
        return this;
    }

    public void clear() {
        this.data.clear();
        this.update();
    }

    public Map<String, Object> getDataMap() {
        return this.data;
    }

    public void refreshDataMap(Map<String, Object> dataMap) {
        this.data.clear();
        this.data.putAll(dataMap);
        this.update();
    }

    public boolean valueIsNull(Object value) {
        return value == null || value.equals("");
    }

    protected <T> T getValueByDefaultValue(Object value, T defaultValue) {
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        Class<?> cs = defaultValue.getClass();
        return (T)SafeKeeperUtils.getValueByType((Object)value, cs);
    }

    @Deprecated
    public void setAttribute(String key, Object value) {
        this.data.put(key, value);
        this.update();
    }

    @Deprecated
    public Object getAttribute(String key) {
        return this.data.get(key);
    }

    @Deprecated
    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Deprecated
    public void removeAttribute(String key) {
        this.data.remove(key);
        this.update();
    }

    @Deprecated
    public void clearAttribute() {
        this.data.clear();
        this.update();
    }

    @Deprecated
    public boolean containsAttribute(String key) {
        return this.data.containsKey(key);
    }

    @Deprecated
    public Set<String> attributeKeys() {
        return this.data.keySet();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getId() {
        return this.id;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public List<SafeKeeperToken> getTokenList() {
        return this.tokenList;
    }
}

