/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.manager;

import cn.safekeeper.common.configuration.SafeKeeperConfiguration;
import cn.safekeeper.common.model.SafeKeeperRequest;
import cn.safekeeper.common.model.SafeKeeperResponse;
import cn.safekeeper.common.model.SafeKeeperStorage;
import cn.safekeeper.common.utils.SafeKeeperUtils;
import cn.safekeeper.core.manager.SafeKeeperManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeKeeperTokenProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeKeeperTokenProcessor.class);
    private String loginType;

    public SafeKeeperTokenProcessor(String loginType) {
        this.loginType = loginType;
    }

    public void setSafeKeeperToken(String tokenValue, int cookieTimeout) {
        SafeKeeperConfiguration config = this.getConfig();
        LOGGER.debug("tokenValue\u503c\u3010{}\u3011,cookie\u5931\u6548\u65f6\u95f4\u3010{}\u3011", (Object)tokenValue, (Object)cookieTimeout);
        SafeKeeperStorage storage = SafeKeeperManager.getSafeKeeperContext().getStorage();
        String tokenPrefix = config.getTokenPrefix();
        LOGGER.debug("tokenPrefix\u524d\u7f00\u3010{}\u3011", (Object)tokenPrefix);
        if (SafeKeeperUtils.isEmpty((String)tokenPrefix)) {
            LOGGER.info("currentCreatedContactKey:\u3010{}\u3011", (Object)this.currentCreatedContactKey());
            storage.set(this.currentCreatedContactKey(), (Object)tokenValue);
        } else {
            storage.set(this.currentCreatedContactKey(), (Object)(tokenPrefix + "-" + tokenValue));
            LOGGER.info("\u524d\u7f00\u5199\u5165\u7684\u6570\u636e\u662f{}", (Object)(tokenPrefix + "-" + tokenValue));
        }
        if (config.isReadFromCookie()) {
            SafeKeeperResponse response = SafeKeeperManager.getSafeKeeperContext().getResponse();
            response.addCookie(this.getSafeKeeperTokenName(), tokenValue, "/", config.getCookieDomain(), cookieTimeout);
            LOGGER.info("\u5b8c\u6210cookie\u7684\u751f\u6210\uff0c\u540d\u79f0{},\u503c{},\u57df\u8303\u56f4{},\u5931\u6548\u65f6\u95f4{}", new Object[]{this.getSafeKeeperTokenName(), tokenValue, config.getCookieDomain(), cookieTimeout});
        }
    }

    public String createKeeperToken(Object loginId) {
        return SafeKeeperManager.getSafeKeeperLogicAction().createToken(loginId, this.loginType);
    }

    public String getTokenValue() {
        SafeKeeperStorage storage = SafeKeeperManager.getSafeKeeperContext().getStorage();
        SafeKeeperRequest request = SafeKeeperManager.getSafeKeeperContext().getRequest();
        SafeKeeperConfiguration config = this.getConfig();
        String keyTokenName = this.getSafeKeeperTokenName();
        LOGGER.info("keyTokenName\u540d\u79f0{}", (Object)keyTokenName);
        String tokenValue = null;
        if (storage.get(this.currentCreatedContactKey()) != null) {
            tokenValue = String.valueOf(storage.get(this.currentCreatedContactKey()));
            LOGGER.info("storage\u91cc\u8bfb\u53d6\u503c{}", (Object)tokenValue);
        }
        if (tokenValue == null && config.isReadFromBody()) {
            tokenValue = request.getParameter(keyTokenName);
            LOGGER.info("request\u53c2\u6570\u91cc\u8bfb\u53d6\u503c{}", (Object)tokenValue);
        }
        if (tokenValue == null && config.isReadFromHead()) {
            tokenValue = request.getHeader(keyTokenName);
            LOGGER.info("request\u5934\u90e8\u91cc\u8bfb\u53d6\u503c{}", (Object)tokenValue);
        }
        if (tokenValue == null && config.isReadFromCookie()) {
            tokenValue = request.getCookieValue(keyTokenName);
            LOGGER.info("request\u7684cookie\u91cc\u8bfb\u53d6\u503c{}", (Object)tokenValue);
        }
        return tokenValue;
    }

    public String getSafeKeeperTokenName() {
        return this.getTokenNameFromConfig();
    }

    public String getTokenNameFromConfig() {
        return this.getConfig().getSafeKeeperName();
    }

    public SafeKeeperConfiguration getConfig() {
        return SafeKeeperManager.getConfig();
    }

    public String currentCreatedContactKey() {
        return "CURRENT_CREATED_KEY_" + this.loginType;
    }

    public String getLoginType() {
        return this.loginType;
    }
}

