/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.manager;

import cn.safekeeper.common.annotations.SafeKeeperCondition;
import cn.safekeeper.common.annotations.SafeKeeperHasLogin;
import cn.safekeeper.common.annotations.SafeKeeperHasPermission;
import cn.safekeeper.common.annotations.SafeKeeperHasRole;
import cn.safekeeper.common.configuration.SafeKeeperCodeMsgConfiguration;
import cn.safekeeper.common.configuration.SafeKeeperConfiguration;
import cn.safekeeper.common.exception.SafeKeeperException;
import cn.safekeeper.common.exception.SafeKeeperLoginException;
import cn.safekeeper.common.exception.SafeKeeperPermissionException;
import cn.safekeeper.common.exception.SafeKeeperRoleException;
import cn.safekeeper.common.model.SafeKeeperStorage;
import cn.safekeeper.common.model.SafeKeeperTokenInfo;
import cn.safekeeper.common.model.SafeKeeperValueObject;
import cn.safekeeper.common.utils.SafeKeeperUtils;
import cn.safekeeper.core.manager.SafeKeeperAuthenticationProcessor;
import cn.safekeeper.core.manager.SafeKeeperManager;
import cn.safekeeper.core.manager.SafeKeeperTokenProcessor;
import cn.safekeeper.core.session.SafeKeeperSession;
import cn.safekeeper.core.session.SafeKeeperToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeKeeperProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeKeeperProcessor.class);
    public String loginType;
    private String forbidden_flag = "forbidden";
    private SafeKeeperTokenProcessor safeKeeperTokenProcessor;
    private SafeKeeperAuthenticationProcessor safeKeeperAuthenticationProcessor;
    private SafeKeeperCodeMsgConfiguration safeKeeperCodeMsgConfiguration = SafeKeeperManager.getSafeKeeperCodeMsg();

    public SafeKeeperProcessor(String loginType) {
        LOGGER.debug("\u521d\u59cb\u5316SafeKeeperProcessor loginType\uff1a\u3010" + loginType + "\u3011");
        if (SafeKeeperUtils.isEmpty((String)loginType)) {
            throw new SafeKeeperException("loginType must not null");
        }
        this.loginType = loginType;
        this.safeKeeperTokenProcessor = new SafeKeeperTokenProcessor(loginType);
        this.safeKeeperAuthenticationProcessor = new SafeKeeperAuthenticationProcessor(loginType, this.safeKeeperTokenProcessor);
        SafeKeeperManager.putSafeKeeperProcessor(this);
        LOGGER.debug("\u521d\u59cb\u5316SafeKeeperProcessor\u5b8c\u6210...\u5e76\u4e14\u52a0\u5165\u5230SafeKeeperManager");
    }

    public String getLoginType() {
        return this.safeKeeperTokenProcessor.getLoginType();
    }

    public String getSafeKeeperTokenName() {
        return this.safeKeeperTokenProcessor.getTokenNameFromConfig();
    }

    public String createKeeperToken(Object loginId) {
        return this.safeKeeperTokenProcessor.createKeeperToken(loginId);
    }

    public void setSafeKeeperToken(String tokenValue, int cookieTimeout) {
        this.safeKeeperTokenProcessor.setSafeKeeperToken(tokenValue, cookieTimeout);
    }

    public String getTokenValue() {
        return this.safeKeeperTokenProcessor.getTokenValue();
    }

    public SafeKeeperTokenInfo getTokenInfo() {
        SafeKeeperTokenInfo info = new SafeKeeperTokenInfo();
        info.setTokenName(this.getSafeKeeperTokenName());
        info.setTokenValue(this.getTokenValue());
        info.setIsLogin(Boolean.valueOf(this.isLogin()));
        info.setLoginId(this.safeKeeperAuthenticationProcessor.getLoginIdDefaultNull());
        info.setLoginType(this.getLoginType());
        info.setTokenTimeout(this.getTokenTimeout());
        info.setSessionTimeout(this.getSessionTimeout());
        info.setTokenSessionTimeout(this.getTokenSessionTimeout());
        info.setTokenActivityTimeout(this.getTokenActivityTimeout());
        info.setLoginDevice(this.getLoginDevice());
        LOGGER.debug("SafeKeeperTokenInfo\u5bf9\u8c61\u6570\u636e\u4fe1\u606f:{}", (Object)info);
        return info;
    }

    public void login(Object id) {
        this.safeKeeperAuthenticationProcessor.login(id, new SafeKeeperValueObject());
    }

    public void login(Object id, String device) {
        this.safeKeeperAuthenticationProcessor.login(id, new SafeKeeperValueObject().setDevice(device));
    }

    public void login(Object id, boolean isPersistent) {
        this.safeKeeperAuthenticationProcessor.login(id, new SafeKeeperValueObject().setIsPersistent(Boolean.valueOf(isPersistent)));
    }

    public void logout() {
        this.safeKeeperAuthenticationProcessor.logout();
    }

    public void logoutByLoginId(Object loginId) {
        this.safeKeeperAuthenticationProcessor.logoutByLoginId(loginId, null);
    }

    public boolean isLogin() {
        return this.safeKeeperAuthenticationProcessor.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.safeKeeperAuthenticationProcessor.getLoginId();
    }

    public Object getLoginIdByToken(String tokenValue) {
        return this.safeKeeperAuthenticationProcessor.getLoginIdNotHandle(tokenValue);
    }

    public SafeKeeperSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SafeKeeperSession safeKeeperSession = SafeKeeperManager.getSafeKeeperTokenRealm().getSession(sessionId);
        if (safeKeeperSession == null && isCreate) {
            safeKeeperSession = SafeKeeperManager.getSafeKeeperLogicAction().createSession(sessionId);
            SafeKeeperManager.getSafeKeeperTokenRealm().setSession(safeKeeperSession, this.getConfig().getTimeout());
        }
        return safeKeeperSession;
    }

    public SafeKeeperSession getSessionBySessionId(String sessionId) {
        return this.getSessionBySessionId(sessionId, false);
    }

    public SafeKeeperSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate);
    }

    public SafeKeeperSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(loginId, true);
    }

    public SafeKeeperSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.safeKeeperAuthenticationProcessor.getLoginId(), isCreate);
    }

    public SafeKeeperSession getSession() {
        return this.getSession(true);
    }

    public SafeKeeperSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate);
    }

    public SafeKeeperSession getTokenSessionByToken(String tokenValue) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), true);
    }

    public SafeKeeperSession getTokenSession(boolean isCreate) {
        if (this.getConfig().getTokenSessionCheckLogin().booleanValue()) {
            this.checkLogin();
        } else {
            String tokenValue = this.getTokenValue();
            if (tokenValue == null || Objects.equals(tokenValue, "")) {
                tokenValue = this.createKeeperToken(null);
                this.setLastActivityToNow(tokenValue);
                int cookieTimeout = (int)(this.getConfig().getTimeout() == -1L ? Integer.MAX_VALUE : this.getConfig().getTimeout());
                this.setSafeKeeperToken(tokenValue, cookieTimeout);
            }
        }
        return this.getSessionBySessionId(this.splicingKeyTokenSession(this.getTokenValue()), isCreate);
    }

    public SafeKeeperSession getTokenSession() {
        return this.getTokenSession(true);
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().set(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), this.getConfig().getTimeout());
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().delete(this.splicingKeyLastActivityTime(tokenValue));
        SafeKeeperManager.getSafeKeeperContext().getStorage().delete("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperStorage storage = SafeKeeperManager.getSafeKeeperContext().getStorage();
        if (storage.get("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == -1L) {
            return;
        }
        if (timeout == -2L) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeout()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeoutMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        storage.set("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", (Object)true);
    }

    public void checkActivityTimeout() {
        this.checkActivityTimeout(this.getTokenValue());
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().update(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void updateLastActivityToNow() {
        this.updateLastActivityToNow(this.getTokenValue());
    }

    public long getTokenTimeout() {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getTimeout(this.splicingKeyTokenValue(this.getTokenValue()));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getTimeout(this.splicingKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.safeKeeperAuthenticationProcessor.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getSessionTimeout(this.splicingKeySession(loginId));
    }

    public long getTokenSessionTimeout() {
        return this.getTokenSessionTimeoutByTokenValue(this.getTokenValue());
    }

    public long getTokenSessionTimeoutByTokenValue(String tokenValue) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getSessionTimeout(this.splicingKeyTokenSession(tokenValue));
    }

    public long getTokenActivityTimeout() {
        return this.getTokenActivityTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return -2L;
        }
        if (this.getConfig().getActivityTimeout() == -1L) {
            return -1L;
        }
        String keyLastActivityTime = this.splicingKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = SafeKeeperManager.getSafeKeeperTokenRealm().get(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return -2L;
        }
        long lastActivityTime = Long.parseLong(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = this.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return -2L;
        }
        return timeout;
    }

    public boolean hasRole(Object loginId, String role) {
        List roleList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getRoleList(loginId, this.loginType);
        return SafeKeeperManager.getSafeKeeperLogicAction().hasElement(roleList, role);
    }

    public boolean hasRole(String role) {
        return this.hasRole(this.safeKeeperAuthenticationProcessor.getLoginId(), role);
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            SafeKeeperRoleException exception = new SafeKeeperRoleException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getRolNotHas()).setRole(role).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public void checkRoleAnd(String ... roleArray) {
        Object loginId = this.safeKeeperAuthenticationProcessor.getLoginId();
        List roleList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getRoleList(loginId, this.loginType);
        for (String role : roleArray) {
            if (SafeKeeperManager.getSafeKeeperLogicAction().hasElement(roleList, role)) continue;
            SafeKeeperRoleException exception = new SafeKeeperRoleException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getRolNotHas()).setRole(role).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public void checkRoleOr(String ... roleArray) {
        Object loginId = this.safeKeeperAuthenticationProcessor.getLoginId();
        List roleList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getRoleList(loginId, this.loginType);
        for (String role : roleArray) {
            if (!SafeKeeperManager.getSafeKeeperLogicAction().hasElement(roleList, role)) continue;
            return;
        }
        if (roleArray.length > 0) {
            SafeKeeperRoleException exception = new SafeKeeperRoleException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getRolNotHas()).setRole(roleArray[0]).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public boolean hasPermission(Object loginId, String permission) {
        List permissionList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getPermissionList(loginId, this.loginType);
        return SafeKeeperManager.getSafeKeeperLogicAction().hasElement(permissionList, permission);
    }

    public boolean hasPermission(String permission) {
        return this.hasPermission(this.safeKeeperAuthenticationProcessor.getLoginId(), permission);
    }

    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            SafeKeeperPermissionException exception = new SafeKeeperPermissionException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getPermissionNotHas()).setPermission(permission).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public void checkPermissionAnd(String ... permissionArray) {
        Object loginId = this.safeKeeperAuthenticationProcessor.getLoginId();
        List permissionList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getPermissionList(loginId, this.loginType);
        for (String permission : permissionArray) {
            if (SafeKeeperManager.getSafeKeeperLogicAction().hasElement(permissionList, permission)) continue;
            SafeKeeperPermissionException exception = new SafeKeeperPermissionException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getPermissionNotHas()).setPermission(permission).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public void checkPermissionOr(String ... permissionArray) {
        Object loginId = this.safeKeeperAuthenticationProcessor.getLoginId();
        List permissionList = SafeKeeperManager.getSafeKeeperAuthorizationCallBack().getPermissionList(loginId, this.loginType);
        for (String permission : permissionArray) {
            if (!SafeKeeperManager.getSafeKeeperLogicAction().hasElement(permissionList, permission)) continue;
            return;
        }
        if (permissionArray.length > 0) {
            SafeKeeperPermissionException exception = new SafeKeeperPermissionException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getPermissionNotHas()).setPermission(permissionArray[0]).setLoginType(this.loginType).build();
            throw exception;
        }
    }

    public String getTokenValueByLoginId(Object loginId) {
        return this.getTokenValueByLoginId(loginId, "safe");
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public List<String> getTokenValueListByLoginId(Object loginId) {
        return this.getTokenValueListByLoginId(loginId, "safe");
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SafeKeeperSession safeKeeperSession = this.getSessionByLoginId(loginId, false);
        if (safeKeeperSession == null) {
            return Collections.emptyList();
        }
        List<SafeKeeperToken> safeKeeperTokenList = safeKeeperSession.getTokenList();
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (SafeKeeperToken safeKeeperToken : safeKeeperTokenList) {
            if (!safeKeeperToken.getDevice().equals(device)) continue;
            tokenValueList.add(safeKeeperToken.getValue());
        }
        return tokenValueList;
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        SafeKeeperSession safeKeeperSession = this.getSessionByLoginId(this.safeKeeperAuthenticationProcessor.getLoginIdDefaultNull(), false);
        if (safeKeeperSession == null) {
            return null;
        }
        List<SafeKeeperToken> safeKeeperTokenList = safeKeeperSession.getTokenList();
        for (SafeKeeperToken safeKeeperToken : safeKeeperTokenList) {
            if (!safeKeeperToken.getValue().equals(tokenValue)) continue;
            return safeKeeperToken.getDevice();
        }
        return null;
    }

    public void checkByAnnotation(SafeKeeperHasLogin at) {
        this.checkLogin();
    }

    public void checkByAnnotation(SafeKeeperHasRole at) {
        String[] roleArray = at.roles();
        if (at.mode() == SafeKeeperCondition.AND) {
            this.checkRoleAnd(roleArray);
        } else {
            this.checkRoleOr(roleArray);
        }
    }

    public void checkByAnnotation(SafeKeeperHasPermission at) {
        String[] permissionArray = at.permissions();
        if (at.mode() == SafeKeeperCondition.AND) {
            this.checkPermissionAnd(permissionArray);
        } else {
            this.checkPermissionOr(permissionArray);
        }
    }

    public void forbidden(Object loginId, long disableTime) {
        SafeKeeperManager.getSafeKeeperTokenRealm().set(this.safeKeeperAuthenticationProcessor.accountForbidden(loginId), "disable", disableTime);
        SafeKeeperManager.getSafeKeeperTokenListener().doDisable(this.loginType, loginId, disableTime);
    }

    public boolean isForbidden(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().get(this.safeKeeperAuthenticationProcessor.accountForbidden(loginId)) != null;
    }

    public long getForbiddenTime(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getTimeout(this.safeKeeperAuthenticationProcessor.accountForbidden(loginId));
    }

    public void untieForbidden(Object loginId) {
        SafeKeeperManager.getSafeKeeperTokenRealm().delete(this.safeKeeperAuthenticationProcessor.accountForbidden(loginId));
        SafeKeeperManager.getSafeKeeperTokenListener().doUntieDisable(this.loginType, loginId);
    }

    public void switchToTmp(Object loginId) {
        SafeKeeperManager.getSafeKeeperContext().getStorage().set(this.splicingKeySwitch(), loginId);
    }

    public void endSwitchTmp() {
        SafeKeeperManager.getSafeKeeperContext().getStorage().delete(this.splicingKeySwitch());
    }

    public void openSecondSafe(long safeTime) {
        long eff = System.currentTimeMillis() + safeTime * 1000L;
        this.getTokenSession().set("SAFE_AUTH_SAVE_KEY_", eff);
    }

    public boolean isSecondSafe() {
        long eff = this.getTokenSession().get("SAFE_AUTH_SAVE_KEY_", 0L);
        return eff != 0L && eff >= System.currentTimeMillis();
    }

    public void checkSecondSafe() {
        if (!this.isSecondSafe()) {
            throw new SafeKeeperException();
        }
    }

    public long getSecondSafeTime() {
        long eff = this.getTokenSession().get("SAFE_AUTH_SAVE_KEY_", 0L);
        if (eff == 0L || eff < System.currentTimeMillis()) {
            return -2L;
        }
        return (eff - System.currentTimeMillis()) / 1000L;
    }

    public void closeSecondSafe() {
        this.getTokenSession().delete("SAFE_AUTH_SAVE_KEY_");
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return this.getConfig().getSafeKeeperName() + ":" + this.loginType + ":token:" + tokenValue;
    }

    public String splicingKeySession(Object loginId) {
        return this.getConfig().getSafeKeeperName() + ":" + this.loginType + ":session:" + loginId;
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return this.getConfig().getSafeKeeperName() + ":" + this.loginType + ":token-session:" + tokenValue;
    }

    public String splicingKeyLastActivityTime(String tokenValue) {
        return this.getConfig().getSafeKeeperName() + ":" + this.loginType + ":last-activity:" + tokenValue;
    }

    public String splicingKeySwitch() {
        return "SWITCH_TO_SAVE_KEY_" + this.loginType;
    }

    public SafeKeeperConfiguration getConfig() {
        return SafeKeeperManager.getConfig();
    }

    public String getForbidden_flag() {
        return this.forbidden_flag;
    }

    public SafeKeeperTokenProcessor getSafeKeeperTokenProcessor() {
        return this.safeKeeperTokenProcessor;
    }

    public SafeKeeperAuthenticationProcessor getSafeKeeperAuthenticationProcessor() {
        return this.safeKeeperAuthenticationProcessor;
    }

    public SafeKeeperCodeMsgConfiguration getSafeKeeperCodeMsgConfiguration() {
        return this.safeKeeperCodeMsgConfiguration;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public void setForbidden_flag(String forbidden_flag) {
        this.forbidden_flag = forbidden_flag;
    }

    public void setSafeKeeperTokenProcessor(SafeKeeperTokenProcessor safeKeeperTokenProcessor) {
        this.safeKeeperTokenProcessor = safeKeeperTokenProcessor;
    }

    public void setSafeKeeperAuthenticationProcessor(SafeKeeperAuthenticationProcessor safeKeeperAuthenticationProcessor) {
        this.safeKeeperAuthenticationProcessor = safeKeeperAuthenticationProcessor;
    }

    public void setSafeKeeperCodeMsgConfiguration(SafeKeeperCodeMsgConfiguration safeKeeperCodeMsgConfiguration) {
        this.safeKeeperCodeMsgConfiguration = safeKeeperCodeMsgConfiguration;
    }
}

