/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.manager;

import cn.safekeeper.common.configuration.SafeKeeperCodeMsgConfiguration;
import cn.safekeeper.common.configuration.SafeKeeperConfiguration;
import cn.safekeeper.common.exception.SafeKeeperException;
import cn.safekeeper.common.model.SafeKeeperAuthorizationCallBack;
import cn.safekeeper.common.model.SafeKeeperContext;
import cn.safekeeper.common.utils.SafeKeeperUtils;
import cn.safekeeper.core.listener.DefaultSafeKeeperTokenListener;
import cn.safekeeper.core.listener.SafeKeeperTokenListener;
import cn.safekeeper.core.logic.DefaultSafeKeeperLogicAction;
import cn.safekeeper.core.logic.SafeKeeperLogicAction;
import cn.safekeeper.core.manager.SafeKeeperProcessor;
import cn.safekeeper.core.manager.SafeKeeperTokenRealm;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SafeKeeperManager {
    private static SafeKeeperConfiguration config;
    private static SafeKeeperTokenRealm safeKeeperTokenRealm;
    private static SafeKeeperAuthorizationCallBack authorizationCallBack;
    private static SafeKeeperLogicAction safeKeeperLogicAction;
    private static SafeKeeperContext safeKeeperContext;
    private static SafeKeeperTokenListener tokenListener;
    private static volatile boolean isTokenListenerInit;
    private static SafeKeeperCodeMsgConfiguration safeKeeperCodeMsgConfiguration;
    public static Map<String, SafeKeeperProcessor> safeKeeperLogicMap;

    public static void setConfig(SafeKeeperConfiguration config) {
        SafeKeeperManager.config = config;
        if (config.isPrint()) {
            SafeKeeperUtils.printSaToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperConfiguration getConfig() {
        if (config != null) return config;
        Class<SafeKeeperConfiguration> clazz = SafeKeeperConfiguration.class;
        synchronized (SafeKeeperConfiguration.class) {
            if (config != null) return config;
            System.err.println("config \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9ed8\u8ba4\u521d\u59cb\u5316\uff0c\u7a0b\u5e8f\u76f4\u63a5\u505c\u6b62...");
            System.exit(1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public static void setSafeKeeperTokenRealm(SafeKeeperTokenRealm safeKeeperTokenRealm) {
        SafeKeeperManager.safeKeeperTokenRealm = safeKeeperTokenRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperTokenRealm getSafeKeeperTokenRealm() {
        if (safeKeeperTokenRealm != null) return safeKeeperTokenRealm;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (safeKeeperTokenRealm != null) return safeKeeperTokenRealm;
            System.err.println("safeKeeperTokenDaoStorage \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9ed8\u8ba4\u521d\u59cb\u5316\uff0c\u7a0b\u5e8f\u76f4\u63a5\u505c\u6b62...");
            System.exit(1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return safeKeeperTokenRealm;
        }
    }

    public static void setSafeKeeperAuthorizationCallBack(SafeKeeperAuthorizationCallBack authorizationCallBack) {
        SafeKeeperManager.authorizationCallBack = authorizationCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperAuthorizationCallBack getSafeKeeperAuthorizationCallBack() {
        if (authorizationCallBack != null) return authorizationCallBack;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (authorizationCallBack != null) return authorizationCallBack;
            System.err.println("authorizationCallBack \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9ed8\u8ba4\u521d\u59cb\u5316\uff0c\u7a0b\u5e8f\u76f4\u63a5\u505c\u6b62...");
            System.exit(1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return authorizationCallBack;
        }
    }

    public static void setSafeKeeperLogicAction(SafeKeeperLogicAction safeKeeperLogicAction) {
        SafeKeeperManager.safeKeeperLogicAction = safeKeeperLogicAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperLogicAction getSafeKeeperLogicAction() {
        if (safeKeeperLogicAction != null) return safeKeeperLogicAction;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (safeKeeperLogicAction != null) return safeKeeperLogicAction;
            SafeKeeperManager.setSafeKeeperLogicAction(new DefaultSafeKeeperLogicAction());
            // ** MonitorExit[var0] (shouldn't be in output)
            return safeKeeperLogicAction;
        }
    }

    public static void setSafeKeeperContext(SafeKeeperContext safeKeeperContext) {
        SafeKeeperManager.safeKeeperContext = safeKeeperContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperContext getSafeKeeperContext() {
        if (safeKeeperContext != null) return safeKeeperContext;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (safeKeeperContext != null) return safeKeeperContext;
            System.err.println("safeKeeperContext \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9ed8\u8ba4\u521d\u59cb\u5316\uff0c\u7a0b\u5e8f\u76f4\u63a5\u505c\u6b62...");
            System.exit(1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return safeKeeperContext;
        }
    }

    public static void setSafeKeeperTokenListener(SafeKeeperTokenListener tokenListener) {
        if (isTokenListenerInit) {
            return;
        }
        isTokenListenerInit = true;
        SafeKeeperManager.tokenListener = tokenListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperTokenListener getSafeKeeperTokenListener() {
        if (tokenListener != null) return tokenListener;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (tokenListener != null) return tokenListener;
            SafeKeeperManager.setSafeKeeperTokenListener(new DefaultSafeKeeperTokenListener());
            // ** MonitorExit[var0] (shouldn't be in output)
            return tokenListener;
        }
    }

    public static void setSafeKeeperCodeMsgConfiguration(SafeKeeperCodeMsgConfiguration safeKeeperCodeMsgConfiguration) {
        SafeKeeperManager.safeKeeperCodeMsgConfiguration = safeKeeperCodeMsgConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SafeKeeperCodeMsgConfiguration getSafeKeeperCodeMsg() {
        if (safeKeeperCodeMsgConfiguration != null) return safeKeeperCodeMsgConfiguration;
        Class<SafeKeeperManager> clazz = SafeKeeperManager.class;
        synchronized (SafeKeeperManager.class) {
            if (safeKeeperCodeMsgConfiguration != null) return safeKeeperCodeMsgConfiguration;
            SafeKeeperManager.setSafeKeeperCodeMsgConfiguration(new SafeKeeperCodeMsgConfiguration());
            // ** MonitorExit[var0] (shouldn't be in output)
            return safeKeeperCodeMsgConfiguration;
        }
    }

    public static void putSafeKeeperProcessor(SafeKeeperProcessor safeKeeperProcessor) {
        safeKeeperLogicMap.put(safeKeeperProcessor.getLoginType(), safeKeeperProcessor);
    }

    public static SafeKeeperProcessor getSafeKeeperProcessor(String loginType) {
        if (SafeKeeperUtils.isEmpty((String)loginType)) {
            throw new SafeKeeperException("loginType must not null");
        }
        SafeKeeperProcessor safeKeeperProcessor = safeKeeperLogicMap.get(loginType);
        if (safeKeeperProcessor == null) {
            return new SafeKeeperProcessor(loginType);
        }
        return safeKeeperProcessor;
    }

    static {
        isTokenListenerInit = false;
        safeKeeperLogicMap = new ConcurrentHashMap<String, SafeKeeperProcessor>();
    }
}

