/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.manager;

import cn.safekeeper.common.configuration.SafeKeeperCodeMsgConfiguration;
import cn.safekeeper.common.configuration.SafeKeeperConfiguration;
import cn.safekeeper.common.exception.SafeKeeperLockedException;
import cn.safekeeper.common.exception.SafeKeeperLoginException;
import cn.safekeeper.common.model.SafeKeeperStorage;
import cn.safekeeper.common.model.SafeKeeperValueObject;
import cn.safekeeper.core.manager.SafeKeeperManager;
import cn.safekeeper.core.manager.SafeKeeperTokenProcessor;
import cn.safekeeper.core.manager.SafeKeeperTokenRealm;
import cn.safekeeper.core.session.SafeKeeperSession;
import cn.safekeeper.core.session.SafeKeeperToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeKeeperAuthenticationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeKeeperAuthenticationProcessor.class);
    public String loginType;
    private String forbidden_flag = "forbidden";
    private SafeKeeperTokenProcessor safeKeeperTokenProcessor;
    private SafeKeeperCodeMsgConfiguration safeKeeperCodeMsgConfiguration = SafeKeeperManager.getSafeKeeperCodeMsg();

    public SafeKeeperAuthenticationProcessor(String loginType, SafeKeeperTokenProcessor safeKeeperTokenProcessor) {
        this.loginType = loginType;
        this.safeKeeperTokenProcessor = safeKeeperTokenProcessor;
    }

    public void login(Object id) {
        this.login(id, new SafeKeeperValueObject());
    }

    public void login(Object id, String device) {
        this.login(id, new SafeKeeperValueObject().setDevice(device));
    }

    public void login(Object id, boolean isPersistent) {
        this.login(id, new SafeKeeperValueObject().setIsPersistent(Boolean.valueOf(isPersistent)));
    }

    public boolean isDisable(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().get(this.accountForbidden(loginId)) != null;
    }

    public String accountForbidden(Object loginId) {
        return this.forbidden_flag + ":" + SafeKeeperManager.getConfig().getSafeKeeperName() + ":" + this.loginType + ":" + loginId;
    }

    public long getDisableTime(Object loginId) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().getTimeout(this.accountForbidden(loginId));
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SafeKeeperSession safeKeeperSession = this.getSessionByLoginId(loginId, false);
        if (safeKeeperSession == null) {
            return Collections.emptyList();
        }
        List<SafeKeeperToken> safeKeeperTokenList = safeKeeperSession.getTokenList();
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (SafeKeeperToken safeKeeperToken : safeKeeperTokenList) {
            if (!safeKeeperToken.getDevice().equals(device)) continue;
            tokenValueList.add(safeKeeperToken.getValue());
        }
        return tokenValueList;
    }

    public SafeKeeperSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate);
    }

    public String splicingKeySession(Object loginId) {
        return SafeKeeperManager.getConfig().getSafeKeeperName() + ":" + this.loginType + ":session:" + loginId;
    }

    public SafeKeeperSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SafeKeeperSession safeKeeperSession = SafeKeeperManager.getSafeKeeperTokenRealm().getSession(sessionId);
        if (safeKeeperSession == null && isCreate) {
            safeKeeperSession = SafeKeeperManager.getSafeKeeperLogicAction().createSession(sessionId);
            SafeKeeperManager.getSafeKeeperTokenRealm().setSession(safeKeeperSession, SafeKeeperManager.getConfig().getTimeout());
        }
        return safeKeeperSession;
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return SafeKeeperManager.getConfig().getSafeKeeperName() + ":" + this.loginType + ":token:" + tokenValue;
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || SafeKeeperManager.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().delete(this.splicingKeyLastActivityTime(tokenValue));
        SafeKeeperManager.getSafeKeeperContext().getStorage().delete("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
    }

    public String splicingKeyLastActivityTime(String tokenValue) {
        return SafeKeeperManager.getConfig().getSafeKeeperName() + ":" + this.loginType + ":last-activity:" + tokenValue;
    }

    public void login(Object id, SafeKeeperValueObject valueObject) {
        SafeKeeperSession safeKeeperSession;
        if (this.isDisable(id)) {
            LOGGER.warn("\u8d26\u53f7\u7981\u7528,\u4e1a\u52a1id{}", id);
            throw new SafeKeeperLockedException(SafeKeeperManager.getSafeKeeperCodeMsg().getLockTheUser(), SafeKeeperManager.getSafeKeeperCodeMsg().getLockTheUserMessage() + "" + this.getDisableTime(id) + "", this.loginType);
        }
        SafeKeeperConfiguration config = SafeKeeperManager.getConfig();
        SafeKeeperTokenRealm dao = SafeKeeperManager.getSafeKeeperTokenRealm();
        valueObject.build(config);
        LOGGER.debug("SafeKeeperValueObject\u6570\u636e:{}", (Object)valueObject);
        String tokenValue = null;
        if (config.isConcurrent()) {
            if (config.isShare()) {
                tokenValue = this.getTokenValueByLoginId(id, valueObject.getDevice());
            }
        } else {
            safeKeeperSession = this.getSessionByLoginId(id, false);
            if (safeKeeperSession != null) {
                List<SafeKeeperToken> safeKeeperTokenList = safeKeeperSession.getTokenList();
                for (SafeKeeperToken safeKeeperToken : safeKeeperTokenList) {
                    if (!safeKeeperToken.getDevice().equals(valueObject.getDevice())) continue;
                    dao.update(this.splicingKeyTokenValue(safeKeeperToken.getValue()), String.valueOf(SafeKeeperManager.getSafeKeeperCodeMsg().getAuthenticationBeReplaced()));
                    this.clearLastActivity(safeKeeperToken.getValue());
                    safeKeeperSession.removeTokenSign(safeKeeperToken.getValue());
                    SafeKeeperManager.getSafeKeeperTokenListener().doReplaced(this.loginType, id, safeKeeperToken.getValue(), safeKeeperToken.getDevice());
                }
            }
        }
        if (tokenValue == null) {
            tokenValue = this.safeKeeperTokenProcessor.createKeeperToken(id);
        }
        if ((safeKeeperSession = this.getSessionByLoginId(id, false)) == null) {
            safeKeeperSession = this.getSessionByLoginId(id, true);
            LOGGER.debug("\u65b0\u5efasession:{}", (Object)safeKeeperSession);
        } else {
            safeKeeperSession.updateMinTimeout(valueObject.getTimeout());
        }
        safeKeeperSession.addTokenSign(new SafeKeeperToken(tokenValue, valueObject.getDevice()));
        dao.set(this.splicingKeyTokenValue(tokenValue), String.valueOf(id), valueObject.getTimeout());
        this.setLastActivityToNow(tokenValue);
        this.safeKeeperTokenProcessor.setSafeKeeperToken(tokenValue, valueObject.getCookieTimeout());
        LOGGER.info("\u5b8c\u6210session\u521b\u5efa");
        SafeKeeperManager.getSafeKeeperTokenListener().doLogin(this.loginType, id, valueObject);
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || SafeKeeperManager.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().set(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), SafeKeeperManager.getConfig().getTimeout());
    }

    public void logout() {
        String tokenValue = this.safeKeeperTokenProcessor.getTokenValue();
        if (tokenValue == null) {
            return;
        }
        if (SafeKeeperManager.getConfig().isReadFromCookie()) {
            SafeKeeperManager.getSafeKeeperContext().getResponse().deleteCookie(this.safeKeeperTokenProcessor.getSafeKeeperTokenName());
        }
        this.logoutByTokenValue(tokenValue);
    }

    public void logoutByTokenValue(String tokenValue) {
        this.clearLastActivity(tokenValue);
        SafeKeeperManager.getSafeKeeperTokenRealm().delete(this.splicingKeyTokenSession(tokenValue));
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || SafeKeeperLoginException.ABNORMAL_LIST.contains(loginId)) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().delete(this.splicingKeyTokenValue(tokenValue));
        SafeKeeperManager.getSafeKeeperTokenListener().doLogout(this.loginType, loginId, tokenValue);
        SafeKeeperSession safeKeeperSession = this.getSessionByLoginId(loginId, false);
        if (safeKeeperSession == null) {
            return;
        }
        safeKeeperSession.removeTokenSign(tokenValue);
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return SafeKeeperManager.getConfig().getSafeKeeperName() + ":" + this.loginType + ":token-session:" + tokenValue;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        return SafeKeeperManager.getSafeKeeperTokenRealm().get(this.splicingKeyTokenValue(tokenValue));
    }

    public void logoutByLoginId(Object loginId, String device) {
        SafeKeeperSession safeKeeperSession = this.getSessionByLoginId(loginId, false);
        if (safeKeeperSession == null) {
            return;
        }
        List<SafeKeeperToken> safeKeeperTokenList = safeKeeperSession.getTokenList();
        for (SafeKeeperToken safeKeeperToken : safeKeeperTokenList) {
            if (device != null && !safeKeeperToken.getDevice().equals(device)) continue;
            String tokenValue = safeKeeperToken.getValue();
            this.clearLastActivity(tokenValue);
            SafeKeeperManager.getSafeKeeperTokenRealm().update(this.splicingKeyTokenValue(tokenValue), String.valueOf(this.safeKeeperCodeMsgConfiguration.getAuthenticationKickOut()));
            safeKeeperSession.removeTokenSign(tokenValue);
            SafeKeeperManager.getSafeKeeperTokenListener().doLogoutByLoginId(this.loginType, loginId, tokenValue, safeKeeperToken.getDevice());
        }
    }

    public Object getLoginId() {
        String tokenValue = this.safeKeeperTokenProcessor.getTokenValue();
        if (tokenValue == null) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationNotToken()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationNotTokenMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationInvalidToken()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationInvalidTokenMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        if (loginId.equals(String.valueOf(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeout()))) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeout()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeoutMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        if (loginId.equals(String.valueOf(this.safeKeeperCodeMsgConfiguration.getAuthenticationBeReplaced()))) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationBeReplaced()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationBeReplacedMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        if (loginId.equals(String.valueOf(this.safeKeeperCodeMsgConfiguration.getAuthenticationKickOut()))) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationKickOut()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationKickOutMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        this.checkActivityTimeout(tokenValue);
        if (SafeKeeperManager.getConfig().isAutoRenew()) {
            this.updateLastActivityToNow(tokenValue);
        }
        return loginId;
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || SafeKeeperManager.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperManager.getSafeKeeperTokenRealm().update(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || SafeKeeperManager.getConfig().getActivityTimeout() == -1L) {
            return;
        }
        SafeKeeperStorage storage = SafeKeeperManager.getSafeKeeperContext().getStorage();
        if (storage.get("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == -1L) {
            return;
        }
        if (timeout == -2L) {
            SafeKeeperLoginException exception = new SafeKeeperLoginException.Builder().setCode(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeout()).setMessage(this.safeKeeperCodeMsgConfiguration.getAuthenticationTokenTimeoutMessage()).setLoginType(this.loginType).build();
            throw exception;
        }
        storage.set("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", (Object)true);
    }

    public Object getLoginIdDefaultNull() {
        String tokenValue = this.safeKeeperTokenProcessor.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || SafeKeeperLoginException.ABNORMAL_LIST.contains(loginId)) {
            return null;
        }
        if (this.getTokenActivityTimeoutByToken(tokenValue) == -2L) {
            return null;
        }
        return loginId;
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return -2L;
        }
        if (SafeKeeperManager.getConfig().getActivityTimeout() == -1L) {
            return -1L;
        }
        String keyLastActivityTime = this.splicingKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = SafeKeeperManager.getSafeKeeperTokenRealm().get(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return -2L;
        }
        long lastActivityTime = Long.parseLong(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = SafeKeeperManager.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return -2L;
        }
        return timeout;
    }
}

