/*
 * Decompiled with CFR 0.152.
 */
package cn.safekeeper.core.logic;

import cn.safekeeper.common.annotations.SafeKeeperHasLogin;
import cn.safekeeper.common.annotations.SafeKeeperHasPermission;
import cn.safekeeper.common.annotations.SafeKeeperHasRole;
import cn.safekeeper.common.utils.SafeKeeperUtils;
import cn.safekeeper.core.logic.SafeKeeperLogicAction;
import cn.safekeeper.core.logic.TokenCreatorFactory;
import cn.safekeeper.core.manager.SafeKeeperManager;
import cn.safekeeper.core.session.SafeKeeperSession;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;

public class DefaultSafeKeeperLogicAction
implements SafeKeeperLogicAction {
    @Override
    public String createToken(Object loginId, String loginType) {
        return TokenCreatorFactory.getTokenCreator().createToken(loginId, loginType);
    }

    @Override
    public SafeKeeperSession createSession(String sessionId) {
        return new SafeKeeperSession(sessionId);
    }

    @Override
    public boolean hasElement(List<String> list, String element) {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(element)) {
            return true;
        }
        for (String patter : list) {
            if (!SafeKeeperUtils.vagueMatch((String)patter, (String)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkMethodAnnotation(Method method) {
        this.validateAnnotation(method.getDeclaringClass());
        this.validateAnnotation(method);
    }

    protected void validateAnnotation(AnnotatedElement target) {
        SafeKeeperHasLogin at;
        if (target.isAnnotationPresent(SafeKeeperHasLogin.class)) {
            at = target.getAnnotation(SafeKeeperHasLogin.class);
            SafeKeeperManager.getSafeKeeperProcessor(at.type()).checkByAnnotation(at);
        }
        if (target.isAnnotationPresent(SafeKeeperHasRole.class)) {
            at = target.getAnnotation(SafeKeeperHasRole.class);
            SafeKeeperManager.getSafeKeeperProcessor(at.type()).checkByAnnotation((SafeKeeperHasRole)at);
        }
        if (target.isAnnotationPresent(SafeKeeperHasPermission.class)) {
            at = target.getAnnotation(SafeKeeperHasPermission.class);
            SafeKeeperManager.getSafeKeeperProcessor(at.type()).checkByAnnotation((SafeKeeperHasPermission)at);
        }
    }
}

