/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client.interceptor;

import cn.ruleengine.client.RuleEngineProperties;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestHeaderInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderInterceptor.class);
    private static final String REQUEST_ID = "requestId";
    private static final String ACCESS_KEY_HEADER = "x-access-key";
    private static final String ACCESS_SECRET_HEADER = "x-access-secret";
    private static final String WORKSPACE_HEADER = "x-workspace";
    private final RuleEngineProperties ruleEngineProperties;

    public RequestHeaderInterceptor(RuleEngineProperties ruleEngineProperties) {
        this.ruleEngineProperties = ruleEngineProperties;
    }

    public void apply(RequestTemplate template) {
        log.debug("Start set request headers\uff01");
        template.header(ACCESS_KEY_HEADER, new String[]{this.ruleEngineProperties.getAccessKeyId()});
        template.header(ACCESS_SECRET_HEADER, new String[]{this.ruleEngineProperties.getAccessKeySecret()});
        template.header(WORKSPACE_HEADER, new String[]{this.ruleEngineProperties.getWorkspaceCode()});
        template.header(REQUEST_ID, new String[]{MDC.get((String)REQUEST_ID)});
    }

    public RuleEngineProperties getRuleEngineProperties() {
        return this.ruleEngineProperties;
    }
}

