/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client.handler;

import cn.ruleengine.client.RuleEngineProperties;
import cn.ruleengine.client.cache.Cache;
import cn.ruleengine.client.cache.KeyGenerator;
import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignInvocationHandlerFactory
implements InvocationHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(FeignInvocationHandlerFactory.class);
    private static final String TO_STRING_METHOD = "toString";
    private final RuleEngineProperties ruleEngineProperties;
    private KeyGenerator keyGenerator;
    private Cache cache;

    public FeignInvocationHandlerFactory(RuleEngineProperties ruleEngineProperties, KeyGenerator keyGenerator, Cache cache) {
        this.ruleEngineProperties = ruleEngineProperties;
        this.keyGenerator = keyGenerator;
        this.cache = cache;
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        return (proxy, method, args) -> {
            if (Objects.equals(method.getName(), TO_STRING_METHOD)) {
                return method.getDeclaringClass() + " Proxy Class";
            }
            log.info("Request param is " + Arrays.toString(args));
            InvocationHandlerFactory.MethodHandler methodHandler = (InvocationHandlerFactory.MethodHandler)dispatch.get(method);
            RuleEngineProperties.CacheConfig cacheConfig = this.ruleEngineProperties.getCacheConfig();
            if (!cacheConfig.isEnable()) {
                Object invoke = methodHandler.invoke(args);
                log.info("Direct result is " + invoke);
                return invoke;
            }
            String key = this.keyGenerator.generate(method, args);
            if (this.cache.isExists(key)) {
                log.info("Trigger cache!");
                Object value = this.cache.get(key);
                log.info("Cache result is " + value);
                return value;
            }
            Object invoke = methodHandler.invoke(args);
            this.cache.put(key, invoke, cacheConfig.getTimeout());
            log.info("Query and cache result is " + invoke);
            return invoke;
        };
    }

    public RuleEngineProperties getRuleEngineProperties() {
        return this.ruleEngineProperties;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

