/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client.feign;

import cn.ruleengine.client.RuleEngineProperties;
import cn.ruleengine.client.cache.DefaultCache;
import cn.ruleengine.client.cache.DefaultKeyGenerator;
import cn.ruleengine.client.handler.FeignInvocationHandlerFactory;
import cn.ruleengine.client.interceptor.RequestHeaderInterceptor;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;

public class InterfaceBuilder {
    private final RuleEngineProperties ruleEngineProperties;
    private FeignInvocationHandlerFactory feignInvocationHandlerFactory;
    private RequestHeaderInterceptor requestHeaderInterceptor;

    private InterfaceBuilder(RuleEngineProperties ruleEngineProperties) {
        this.ruleEngineProperties = ruleEngineProperties;
    }

    public static InterfaceBuilder create(RuleEngineProperties ruleEngineProperties) {
        return new InterfaceBuilder(ruleEngineProperties);
    }

    public InterfaceBuilder feignInvocationHandlerFactory(FeignInvocationHandlerFactory feignInvocationHandlerFactory) {
        this.feignInvocationHandlerFactory = feignInvocationHandlerFactory;
        return this;
    }

    public InterfaceBuilder requestHeaderInterceptor(RequestHeaderInterceptor requestHeaderInterceptor) {
        this.requestHeaderInterceptor = requestHeaderInterceptor;
        return this;
    }

    public <T> T build(Class<T> clazz) {
        if (this.feignInvocationHandlerFactory == null) {
            DefaultKeyGenerator defaultKeyGenerator = new DefaultKeyGenerator();
            DefaultCache defaultCache = new DefaultCache();
            this.feignInvocationHandlerFactory = new FeignInvocationHandlerFactory(this.ruleEngineProperties, defaultKeyGenerator, defaultCache);
        }
        if (this.requestHeaderInterceptor == null) {
            this.requestHeaderInterceptor = new RequestHeaderInterceptor(this.ruleEngineProperties);
        }
        RuleEngineProperties.FeignConfig feignConfig = this.ruleEngineProperties.getFeignConfig();
        RuleEngineProperties.FeignConfig.Request request = feignConfig.getRequest();
        RuleEngineProperties.FeignConfig.Retryer retryer = feignConfig.getRetryer();
        return (T)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).options(new Request.Options(request.getConnectTimeoutMillis(), request.getReadTimeoutMillis())).retryer((Retryer)new Retryer.Default(retryer.getPeriod(), retryer.getMaxPeriod(), retryer.getMaxAttempts())).invocationHandlerFactory((InvocationHandlerFactory)this.feignInvocationHandlerFactory).requestInterceptor((RequestInterceptor)this.requestHeaderInterceptor).target(clazz, this.ruleEngineProperties.getBaseUrl());
    }
}

