/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client.cache;

import cn.ruleengine.client.cache.Cache;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class DefaultCache
implements Cache {
    protected Map<String, CacheObj<String, Object>> cacheMap;
    private final StampedLock lock = new StampedLock();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;

    public DefaultCache() {
        this(5000);
    }

    public DefaultCache(int capacity) {
        this(capacity, 0L);
    }

    public void put(String key, Object object) {
        this.put(key, object, this.timeout);
    }

    public DefaultCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new FixedLinkedHashMap<String, CacheObj<String, Object>>(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void putWithoutLock(String key, Object object, long timeout) {
        CacheObj<String, Object> co = new CacheObj<String, Object>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(key, co);
    }

    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public Object get(String key) {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key, boolean isUpdateLastAccess) {
        long stamp = this.lock.tryOptimisticRead();
        CacheObj<String, Object> co = this.cacheMap.get(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.cacheMap.get(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (null == co) {
            return null;
        }
        if (!co.isExpired()) {
            return co.get(isUpdateLastAccess);
        }
        this.remove(key);
        return null;
    }

    @Override
    public boolean isExists(String key) {
        return this.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        long stamp = this.lock.readLock();
        try {
            CacheObj<String, Object> co = this.cacheMap.get(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        this.remove(key);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String key) {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.remove(key);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return;
        }
        Iterator<CacheObj<String, Object>> values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj<String, Object> co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
        }
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    static class CacheObj<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final K key;
        protected final V obj;
        private volatile long lastAccess;
        private final long ttl;

        protected CacheObj(K key, V obj, long ttl) {
            this.key = key;
            this.obj = obj;
            this.ttl = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.ttl > 0L) {
                return System.currentTimeMillis() - this.lastAccess > this.ttl;
            }
            return false;
        }

        V get(boolean isUpdateLastAccess) {
            if (isUpdateLastAccess) {
                this.lastAccess = System.currentTimeMillis();
            }
            return this.obj;
        }

        public String toString() {
            return "DefaultCache.CacheObj(key=" + this.getKey() + ", obj=" + this.getObj() + ", lastAccess=" + this.lastAccess + ", ttl=" + this.ttl + ")";
        }

        public K getKey() {
            return this.key;
        }

        public V getObj() {
            return this.obj;
        }
    }

    static class FixedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public FixedLinkedHashMap(int capacity) {
            super(capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }
}

