/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client;

import cn.ruleengine.client.DecisionTable;
import cn.ruleengine.client.GeneralRule;
import cn.ruleengine.client.RuleEngineProperties;
import cn.ruleengine.client.RuleSet;
import cn.ruleengine.client.feign.DecisionTableInterface;
import cn.ruleengine.client.feign.GeneralRuleInterface;
import cn.ruleengine.client.feign.InterfaceBuilder;
import cn.ruleengine.client.feign.RuleSetInterface;
import cn.ruleengine.client.handler.FeignInvocationHandlerFactory;
import cn.ruleengine.client.interceptor.RequestHeaderInterceptor;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RuleEngineClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RuleEngineClient.class);
    private static final long serialVersionUID = 1L;
    private final RuleEngineProperties ruleEngineProperties;
    private DecisionTableInterface decisionTableInterface;
    private GeneralRuleInterface generalRuleInterface;
    private RuleSetInterface ruleSetInterface;
    @Resource
    private RequestHeaderInterceptor requestHeaderInterceptor;
    @Resource
    private FeignInvocationHandlerFactory feignInvocationHandlerFactory;

    public RuleEngineClient() {
        this.ruleEngineProperties = new RuleEngineProperties();
    }

    public RuleEngineClient(String baseUrl, String workspaceCode, String accessKeyId, String accessKeySecret) {
        this.ruleEngineProperties = new RuleEngineProperties();
        this.ruleEngineProperties.setBaseUrl(baseUrl);
        this.ruleEngineProperties.setWorkspaceCode(workspaceCode);
        this.ruleEngineProperties.setAccessKeyId(accessKeyId);
        this.ruleEngineProperties.setAccessKeySecret(accessKeySecret);
    }

    public RuleEngineClient(Supplier<RuleEngineProperties> supplier) {
        Objects.requireNonNull(supplier);
        this.ruleEngineProperties = supplier.get();
    }

    public RuleEngineClient(RuleEngineProperties ruleEngineProperties) {
        Objects.requireNonNull(ruleEngineProperties);
        this.ruleEngineProperties = ruleEngineProperties;
    }

    public DecisionTable decisionTable() {
        if (this.decisionTableInterface == null) {
            this.decisionTableInterface = InterfaceBuilder.create(this.ruleEngineProperties).requestHeaderInterceptor(this.requestHeaderInterceptor).feignInvocationHandlerFactory(this.feignInvocationHandlerFactory).build(DecisionTableInterface.class);
        }
        return new DecisionTable(this.ruleEngineProperties, this.decisionTableInterface);
    }

    public GeneralRule generalRule() {
        if (this.generalRuleInterface == null) {
            this.generalRuleInterface = InterfaceBuilder.create(this.ruleEngineProperties).requestHeaderInterceptor(this.requestHeaderInterceptor).feignInvocationHandlerFactory(this.feignInvocationHandlerFactory).build(GeneralRuleInterface.class);
        }
        return new GeneralRule(this.ruleEngineProperties, this.generalRuleInterface);
    }

    public RuleSet ruleSet() {
        if (this.ruleSetInterface == null) {
            this.ruleSetInterface = InterfaceBuilder.create(this.ruleEngineProperties).requestHeaderInterceptor(this.requestHeaderInterceptor).feignInvocationHandlerFactory(this.feignInvocationHandlerFactory).build(RuleSetInterface.class);
        }
        return new RuleSet(this.ruleEngineProperties, this.ruleSetInterface);
    }

    public RuleEngineProperties getRuleEngineProperties() {
        return this.ruleEngineProperties;
    }

    @Autowired(required=false)
    public void setDecisionTableInterface(DecisionTableInterface decisionTableInterface) {
        this.decisionTableInterface = decisionTableInterface;
    }

    @Autowired(required=false)
    public void setGeneralRuleInterface(GeneralRuleInterface generalRuleInterface) {
        this.generalRuleInterface = generalRuleInterface;
    }

    @Autowired(required=false)
    public void setRuleSetInterface(RuleSetInterface ruleSetInterface) {
        this.ruleSetInterface = ruleSetInterface;
    }

    public void setRequestHeaderInterceptor(RequestHeaderInterceptor requestHeaderInterceptor) {
        this.requestHeaderInterceptor = requestHeaderInterceptor;
    }

    public void setFeignInvocationHandlerFactory(FeignInvocationHandlerFactory feignInvocationHandlerFactory) {
        this.feignInvocationHandlerFactory = feignInvocationHandlerFactory;
    }
}

