/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client;

import cn.ruleengine.client.RuleEngineClient;
import cn.ruleengine.client.RuleEngineProperties;
import cn.ruleengine.client.cache.Cache;
import cn.ruleengine.client.cache.DefaultCache;
import cn.ruleengine.client.cache.DefaultKeyGenerator;
import cn.ruleengine.client.cache.KeyGenerator;
import cn.ruleengine.client.handler.FeignInvocationHandlerFactory;
import cn.ruleengine.client.interceptor.RequestHeaderInterceptor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

public class RuleEngineAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RuleEngineAutoConfiguration.class);
    @Resource
    private RuleEngineProperties ruleEngineProperties;

    @Bean
    public RuleEngineClient ruleEngineClient() {
        log.info("Initialize RuleEngineClient");
        return new RuleEngineClient(this.ruleEngineProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Cache cache() {
        return new DefaultCache(5000, 0L);
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyGenerator keyGenerator() {
        return new DefaultKeyGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public FeignInvocationHandlerFactory feignInvocationHandlerFactory(KeyGenerator keyGenerator, Cache cache) {
        return new FeignInvocationHandlerFactory(this.ruleEngineProperties, keyGenerator, cache);
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestHeaderInterceptor requestHeaderInterceptor() {
        return new RequestHeaderInterceptor(this.ruleEngineProperties);
    }
}

