/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.client;

import cn.ruleengine.client.RuleEngineProperties;
import cn.ruleengine.client.annotation.BatchSymbol;
import cn.ruleengine.client.annotation.InputParameter;
import cn.ruleengine.client.annotation.Model;
import cn.ruleengine.client.exception.ExecuteException;
import cn.ruleengine.client.exception.ValidException;
import cn.ruleengine.client.feign.BaseInterface;
import cn.ruleengine.client.request.BatchExecuteRequest;
import cn.ruleengine.client.request.ExecuteRequest;
import cn.ruleengine.client.request.IsExistsRequest;
import cn.ruleengine.client.response.BaseResult;
import cn.ruleengine.client.response.BatchOutput;
import cn.ruleengine.client.response.Output;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private final RuleEngineProperties ruleEngineProperties;
    private final BaseInterface baseInterface;

    public Executor(RuleEngineProperties ruleEngineProperties, BaseInterface baseInterface) {
        this.ruleEngineProperties = ruleEngineProperties;
        this.baseInterface = baseInterface;
    }

    public Output execute(String code, Map<String, Object> input) {
        Objects.requireNonNull(code);
        Objects.requireNonNull(input);
        ExecuteRequest executeRequest = new ExecuteRequest();
        executeRequest.setCode(code);
        executeRequest.setInput(input);
        BaseResult<Output> baseResult = this.baseInterface.execute(executeRequest);
        if (baseResult.isFail()) {
            throw new ExecuteException(baseResult.getMessage());
        }
        return baseResult.getData();
    }

    public Output execute(@NonNull Object model) {
        Field[] fields;
        this.validRuleModel(model);
        HashMap<String, Object> input = new HashMap<String, Object>();
        for (Field field : fields = model.getClass().getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            Object value = field.get(model);
            input.put(this.analyzeInputParameterCode(field), value);
        }
        return this.execute(this.analyzeCode(model), input);
    }

    private void validRuleModel(Object model) {
        Objects.requireNonNull(model);
        if (!model.getClass().isAnnotationPresent(Model.class)) {
            throw new ValidException("%s Cannot find the @Model annotation", model.getClass());
        }
    }

    private String analyzeCode(Object model) {
        return this.analyzeCode(model.getClass());
    }

    private String analyzeCode(Class<?> clazz) {
        Model ruleModel = clazz.getAnnotation(Model.class);
        String code = ruleModel.code();
        if (StringUtils.isEmpty((Object)code)) {
            code = clazz.getSimpleName();
        }
        return code;
    }

    public boolean isExists(Class<?> clazz) {
        String code = this.analyzeCode(clazz);
        return this.isExists(code);
    }

    public boolean isExists(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return false;
        }
        IsExistsRequest isExistsRequest = new IsExistsRequest();
        isExistsRequest.setCode(code);
        BaseResult<Boolean> baseResult = this.baseInterface.isExists(isExistsRequest);
        if (baseResult.isFail()) {
            throw new ExecuteException(baseResult.getMessage());
        }
        return baseResult.getData();
    }

    public List<BatchOutput> batchExecute(List<?> models) {
        return this.batchExecute(100, -1L, models);
    }

    public List<BatchOutput> batchExecute(@NonNull Integer threadSegNumber, @NonNull Long timeout, @NonNull List<?> models) {
        Objects.requireNonNull(threadSegNumber);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(models);
        if (models.isEmpty()) {
            return Collections.emptyList();
        }
        BatchExecuteRequest batchExecuteRequest = new BatchExecuteRequest();
        batchExecuteRequest.setThreadSegNumber(threadSegNumber);
        batchExecuteRequest.setTimeout(timeout);
        List<BatchExecuteRequest.Content> executeInfos = this.analyzeModels(models);
        batchExecuteRequest.setContents(executeInfos);
        BaseResult<List<BatchOutput>> baseResult = this.baseInterface.batchExecute(batchExecuteRequest);
        if (baseResult.isFail()) {
            throw new ExecuteException(baseResult.getMessage());
        }
        return baseResult.getData();
    }

    private List<BatchExecuteRequest.Content> analyzeModels(List<?> models) {
        ArrayList<BatchExecuteRequest.Content> executeInfos = new ArrayList<BatchExecuteRequest.Content>(models.size());
        for (Object model : models) {
            this.validRuleModel(model);
            HashMap<String, Object> input = new HashMap<String, Object>();
            Field[] fields = model.getClass().getDeclaredFields();
            StringJoiner symbol = null;
            for (Field field : fields) {
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                Object value = field.get(model);
                if (field.isAnnotationPresent(BatchSymbol.class)) {
                    if (symbol == null) {
                        symbol = new StringJoiner(",");
                    }
                    symbol.add(String.valueOf(value));
                }
                input.put(this.analyzeInputParameterCode(field), value);
            }
            BatchExecuteRequest.Content executeInfo = new BatchExecuteRequest.Content();
            if (symbol != null) {
                executeInfo.setSymbol(symbol.toString());
            }
            executeInfo.setCode(this.analyzeCode(model));
            executeInfo.setInput(input);
            executeInfos.add(executeInfo);
        }
        return executeInfos;
    }

    private String analyzeInputParameterCode(Field field) {
        InputParameter inputParameter;
        String code;
        String inputParamCode = field.getName();
        if (field.isAnnotationPresent(InputParameter.class) && !StringUtils.isEmpty((Object)(code = (inputParameter = field.getAnnotation(InputParameter.class)).code()))) {
            inputParamCode = code;
        }
        return inputParamCode;
    }

    public RuleEngineProperties getRuleEngineProperties() {
        return this.ruleEngineProperties;
    }

    public BaseInterface getBaseInterface() {
        return this.baseInterface;
    }
}

