/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.thread;

import cn.ruleengine.collection.CollUtils;
import cn.ruleengine.thread.BatchExecutor;
import cn.ruleengine.thread.Concurrent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Stream;

public class AsyncUtils {
    public static <T, OUT> List<OUT> batch(ExecutorService executorService, List<T> list, int aFew, BatchExecutor<T, OUT> batchExecutor) {
        List<List<T>> lists = CollUtils.subList(list, aFew);
        if (lists.isEmpty()) {
            return Collections.emptyList();
        }
        return AsyncUtils.batch(executorService, lists, batchExecutor);
    }

    public static <T, OUT> List<OUT> batch(ExecutorService executorService, List<List<T>> lists, BatchExecutor<T, OUT> batchExecutor) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (List list : lists) {
            Future future = executorService.submit(() -> {
                ArrayList<Object> outs = new ArrayList<Object>(list.size());
                for (Object in : list) {
                    Object out = null;
                    try {
                        out = batchExecutor.async(in);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        batchExecutor.onError(in, e);
                    }
                    outs.add(out);
                }
                return outs;
            });
            futures.add(future);
        }
        List values = null;
        for (Future future : futures) {
            try {
                List value = (List)future.get();
                if (values == null) {
                    values = value;
                    continue;
                }
                values.addAll(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                Stream.of(future).filter(f -> !f.isDone()).forEach(m -> m.cancel(true));
                return null;
            }
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <OUT> List<OUT> merge(ExecutorService executorService, boolean ignoreException, Concurrent<OUT> ... concurrents) {
        void var6_8;
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        Concurrent<OUT>[] concurrentArray = concurrents;
        int n = concurrentArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            Concurrent<OUT> concurrent = concurrentArray[var6_8];
            Future<Object> future = executorService.submit(() -> {
                Object out = null;
                try {
                    out = concurrent.async();
                }
                catch (Exception e) {
                    if (ignoreException) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                return out;
            });
            futures.add(future);
            ++var6_8;
        }
        ArrayList values = new ArrayList();
        for (Future future : futures) {
            try {
                Object value = future.get();
                values.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                Stream.of(future).filter(f -> !f.isDone()).forEach(m -> m.cancel(true));
                return null;
            }
        }
        return values;
    }
}

