/*
 * Decompiled with CFR 0.152.
 */
package cn.rl520.druid.config;

import cn.rl520.druid.config.RlDynamicDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class RlDynamicDataSourceConfig {
    @ConfigurationProperties(prefix="spring.datasource.base")
    @Bean(name={"baseDataSource"})
    @Primary
    public DruidDataSource baseDataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        ArrayList<WallFilter> filterList = new ArrayList<WallFilter>();
        filterList.add(this.wallFilter(this.wallConfig()));
        druidDataSource.setProxyFilters(filterList);
        return druidDataSource;
    }

    @ConfigurationProperties(prefix="spring.datasource.master")
    @Bean(name={"masterDataSource"})
    @Primary
    public DruidDataSource masterDataSource() {
        DruidDataSource masterDataSource = new DruidDataSource();
        ArrayList<WallFilter> filterList = new ArrayList<WallFilter>();
        filterList.add(this.wallFilter(this.wallConfig()));
        masterDataSource.setProxyFilters(filterList);
        return masterDataSource;
    }

    @ConfigurationProperties(prefix="spring.datasource.read")
    @Bean(name={"readDataSource"})
    public DruidDataSource readDataSource() {
        DruidDataSource readDataSource = new DruidDataSource();
        ArrayList<WallFilter> filterList = new ArrayList<WallFilter>();
        filterList.add(this.wallFilter(this.wallConfig()));
        readDataSource.setProxyFilters(filterList);
        return readDataSource;
    }

    @Bean(name={"dataSource"})
    public RlDynamicDataSource dataSource(@Qualifier(value="baseDataSource") DataSource baseDataSource) {
        RlDynamicDataSource rlDynamicDataSource = new RlDynamicDataSource();
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        targetDataSources.put("baseDataSource", baseDataSource);
        targetDataSources.put("readDataSource", (DataSource)this.readDataSource());
        targetDataSources.put("masterDataSource", (DataSource)this.masterDataSource());
        rlDynamicDataSource.setTargetDataSources(targetDataSources);
        rlDynamicDataSource.setDefaultTargetDataSource(baseDataSource);
        rlDynamicDataSource.afterPropertiesSet();
        return rlDynamicDataSource;
    }

    @Bean(name={"wallFilter"})
    public WallFilter wallFilter(@Qualifier(value="wallConfig") WallConfig wallConfig) {
        WallFilter wallFilter = new WallFilter();
        wallFilter.setConfig(wallConfig);
        return wallFilter;
    }

    @Bean(name={"wallConfig"})
    public WallConfig wallConfig() {
        WallConfig config = new WallConfig();
        config.setMultiStatementAllow(true);
        config.setStrictSyntaxCheck(false);
        return config;
    }

    @Bean
    public ServletRegistrationBean statViewServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/monitor/druid/*"});
        HashMap<String, String> initParas = new HashMap<String, String>();
        initParas.put("allow", "");
        initParas.put("resetEnable", "false");
        bean.setInitParameters(initParas);
        return bean;
    }

    @Bean
    public FilterRegistrationBean webStatFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new WebStatFilter());
        bean.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("exclusions", "*.js,*.css,/monitor/druid/*");
        bean.setInitParameters(initParams);
        return bean;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="dataSource") RlDynamicDataSource dataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactory = new SqlSessionFactoryBean();
        sqlSessionFactory.setDataSource((DataSource)((Object)dataSource));
        sqlSessionFactory.setConfigLocation((Resource)new ClassPathResource("mybatis-config.xml"));
        sqlSessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapping/*.xml"));
        sqlSessionFactory.setFailFast(true);
        return sqlSessionFactory.getObject();
    }
}

