/*
 * Decompiled with CFR 0.152.
 */
package cn.rl520.druid.config;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RlDynamicDataSource
extends AbstractRoutingDataSource
implements ApplicationContextAware {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private ApplicationContext applicationContext;

    protected Object determineCurrentLookupKey() {
        try {
            if (this.getTargetSource().size() == 0 || this.getTargetSource().size() == 1) {
                HashMap dataSources = new HashMap();
                dataSources.putAll(this.applicationContext.getBeansOfType(RlDynamicDataSource.class));
                super.setTargetDataSources(dataSources);
                super.afterPropertiesSet();
            }
        }
        catch (Exception dataSources) {
            // empty catch block
        }
        String key = RlDynamicDataSource.getDataSource();
        if (key == null) {
            key = "baseDataSource";
        }
        return key;
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static String getDataSource() {
        return contextHolder.get();
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    public Map<Object, Object> getTargetSource() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = AbstractRoutingDataSource.class.getDeclaredField("targetDataSources");
        field.setAccessible(true);
        return (Map)field.get((Object)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

