/*
 * Decompiled with CFR 0.152.
 */
package cn.rl520.druid.aspect;

import cn.rl520.druid.aop.RlDataBase;
import cn.rl520.druid.config.RlDynamicDataSource;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class RlDataSourceAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(RlDataSourceAspect.class);

    @Pointcut(value="@annotation(cn.rl520.druid.aop.RlDataBase)")
    public void dataSourcePointCut() {
        log.info("\u6570\u636e\u5e93\u5207\u6362\u5207\u70b9\u5207\u5165");
    }

    @Before(value="dataSourcePointCut()")
    public void aroundHandleLog(JoinPoint joinPoint) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        RlDataBase rlDataBase = method.getAnnotation(RlDataBase.class);
        if (rlDataBase != null && rlDataBase.name() != null && !rlDataBase.name().equals("")) {
            RlDynamicDataSource.setDataSource(rlDataBase.name() + "DataSource");
        } else {
            RlDynamicDataSource.setDataSource("baseDataSource");
        }
        log.info("\u6267\u884c\u63a5\u53e3\u64cd\u4f5c{},\u6570\u636e\u5e93\u6807\u8bc6\u4e3a{}", (Object)request.getRequestURI(), (Object)RlDynamicDataSource.getDataSource());
    }

    public int getOrder() {
        return 0;
    }
}

