package cn.rl520.druid.aspect;

import cn.rl520.druid.aop.RlDataBase;
import cn.rl520.druid.config.RlDynamicDataSource;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * @author wwb
 * @version 1.0
 **/
@Slf4j
@Aspect
@Component
public class RlDataSourceAspect implements Ordered {

    @Pointcut("@annotation(cn.rl520.druid.aop.RlDataBase)")
    public void dataSourcePointCut() {
        log.info("数据库切换切点切入");
    }


    @Before("dataSourcePointCut()")
    public void aroundHandleLog(JoinPoint joinPoint){
        // 获取RequestAttributes
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        // 从获取RequestAttributes中获取HttpServletRequest的信息
        HttpServletRequest request = (HttpServletRequest) requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method  = methodSignature.getMethod();
        RlDataBase rlDataBase = method.getAnnotation(RlDataBase.class);//获得该注解
        if (rlDataBase !=null&& rlDataBase.name()!=null&&!rlDataBase.name().equals("")) {
            RlDynamicDataSource.setDataSource((rlDataBase.name() + "DataSource"));
        }else {
            RlDynamicDataSource.setDataSource("baseDataSource");
        }
        log.info("执行接口操作{},数据库标识为{}",request.getRequestURI(), RlDynamicDataSource.getDataSource());
    }


    @Override
    public int getOrder() {
        return 0;
    }
}
