/*
 * Copyright (c) 2020 Renlm
 * MyUtil is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins.MyResponse;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import cn.hutool.core.collection.CollUtil;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * EasyUI 数据表格
 *
 * @author RenLiMing(任黎明)
 */
@Data
@Accessors(chain = true)
public class Datagrid<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 总数
	 */
	private long total = 0;

	/**
	 * 数据集
	 */
	private List<T> rows;

	/**
	 * 转换列表数据
	 * 
	 * @param <R>
	 * @param datas
	 * @return
	 */
	public static final <R> Datagrid<R> of(List<R> datas) {
		Datagrid<R> datagrid = new Datagrid<R>();
		datagrid.setTotal(CollUtil.size(datas));
		datagrid.setRows(datas);
		return datagrid;
	}

	/**
	 * 转换分页数据
	 * 
	 * @param <R>
	 * @param page
	 * @return
	 */
	public static final <R> Datagrid<R> of(Page<R> page) {
		Datagrid<R> datagrid = new Datagrid<R>();
		datagrid.setTotal(page.getTotal());
		datagrid.setRows(page.getRecords());
		return datagrid;
	}

}
