/*
 * Copyright (c) 2020 Renlm
 * MyUtil is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins.MyResponse;

import java.io.Serializable;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * Layui 数据表格
 *
 * @author RenLiMing(任黎明)
 */
@Data
@Accessors(chain = true)
public class Layui<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 响应码
	 */
	private int code = 0;

	/**
	 * 消息
	 */
	private String msg;

	/**
	 * 数据
	 */
	private T data;

	/**
	 * 响应成功
	 * 
	 * @param <R>
	 * @param data
	 * @return
	 */
	public static <R> Layui<R> success(R data) {
		Layui<R> layui = new Layui<>();
		layui.setData(data);
		return layui;
	}

}
