/*
 * Copyright (c) 2020 Renlm
 * MyUtil is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins.MyResponse;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 响应结果
 *
 * @author Renlm
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Result<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	private int statusCode;

	private String message;

	private T data;

	public static <R> Result<R> of(StatusCode status) {
		return new Result<R>(status.getValue(), status.getReasonPhrase(), null);
	}

	public static <R> Result<R> of(StatusCode status, String message) {
		Result<R> result = Result.of(status);
		return result.setMessage(message);
	}

	public static <R> Result<R> success() {
		return Result.of(StatusCode.OK);
	}

	public static <R> Result<R> success(R data) {
		Result<R> result = success();
		return result.setData(data);
	}

	public static <R> Result<R> error() {
		return Result.of(StatusCode.INTERNAL_SERVER_ERROR);
	}

	public static <R> Result<R> error(String message) {
		return Result.of(StatusCode.INTERNAL_SERVER_ERROR, message);
	}

	public boolean isSuccess() {
		return this.statusCode == StatusCode.OK.getValue();
	}

}
