/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.openhft.compiler.CompilerUtils;

public final class MyCompilerUtil {
    static final String PackageRegex = "(?im)^\\s*package\\s+([^;]+);";
    static final String ClassNameRegex = "(?m)^\\s*public\\s+class\\s+(\\w+)\\b";
    static final String NoteSingleLineRegex = "//.+\\r\\n";
    static final String NoteMultiLineRegex = "/\\*.+?\\*/";

    public static final boolean addClassPath(String dir) {
        return StrUtil.isBlank((CharSequence)dir) ? false : CompilerUtils.addClassPath((String)dir);
    }

    public static final boolean addLibrary(String dirOrJar) {
        if (StrUtil.isBlank((CharSequence)dirOrJar) || !FileUtil.exist((String)dirOrJar)) {
            return false;
        }
        if (FileUtil.isFile((String)dirOrJar)) {
            return "jar".equals(FileUtil.getSuffix((String)dirOrJar)) ? CompilerUtils.addClassPath((String)dirOrJar) : false;
        }
        AtomicInteger cnt = new AtomicInteger();
        FileUtil.loopFiles((Path)Paths.get(dirOrJar, new String[0]), (int)1, file -> "jar".equals(FileNameUtil.getSuffix((File)file))).forEach(file -> {
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ignored) {
                path = file.getAbsolutePath();
            }
            cnt.incrementAndGet();
            CompilerUtils.addClassPath((String)path);
        });
        return cnt.get() > 0;
    }

    public static final Class<?> loadClass(String javaCode) {
        return MyCompilerUtil.loadClass(ClassLoaderUtil.getClassLoader(), javaCode);
    }

    public static final Class<?> loadClassByHash(String javaCode) {
        return MyCompilerUtil.loadClassByHash(ClassLoaderUtil.getClassLoader(), javaCode);
    }

    public static final Class<?> loadClass(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.fetchPackage(cleanCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, javaCode);
    }

    public static final Class<?> loadClassByHash(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        String hashJavaCode = MyCompilerUtil.hashJavaCode(cleanCode, javaCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, hashJavaCode);
    }

    private static final String hashPackage(String cleanCode, String javaCode) {
        return MyCompilerUtil.fetchPackage(cleanCode) + HashUtil.fnvHash((String)javaCode);
    }

    private static final String fetchPackage(String cleanCode) {
        return ReUtil.get((String)PackageRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String fetchClassName(String cleanCode) {
        return ReUtil.get((String)ClassNameRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String hashJavaCode(String cleanCode, String javaCode) {
        String newPkg = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        return ReUtil.replaceAll((CharSequence)javaCode, (String)PackageRegex, (String)("package " + newPkg + ";"));
    }

    private static final String cleanNotes(String javaCode) {
        javaCode.replaceAll(NoteSingleLineRegex, "");
        Pattern pattern = Pattern.compile(NoteMultiLineRegex, 32);
        return pattern.matcher(javaCode).replaceAll("");
    }

    private MyCompilerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

