/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.ValidateObjectInputStream;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.regex.Pattern;
import net.openhft.compiler.CompilerUtils;

public final class MyCompilerUtil {
    static final String PackageRegex = "(?im)^\\s*package\\s+([^;]+);";
    static final String ClassNameRegex = "(?m)^\\s*public\\s+class\\s+(\\w+)\\b";
    static final String NoteSingleLineRegex = "//.+\\r\\n";
    static final String NoteMultiLineRegex = "/\\*.+?\\*/";

    public static boolean addClassPath(String dir) {
        return StrUtil.isBlank((CharSequence)dir) ? false : CompilerUtils.addClassPath((String)dir);
    }

    public static final Class<?> loadClass(String javaCode) {
        return MyCompilerUtil.loadClass(ClassLoaderUtil.getClassLoader(), javaCode);
    }

    public static final Class<?> loadClass(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.fetchPackage(cleanCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, javaCode);
    }

    public static final Class<?> loadClassByHash(String javaCode) {
        return MyCompilerUtil.loadClassByHash(ClassLoaderUtil.getClassLoader(), javaCode);
    }

    public static final Class<?> loadClassByHash(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        String hashJavaCode = MyCompilerUtil.hashJavaCode(cleanCode, javaCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, hashJavaCode);
    }

    public static final <T> T newInstance(Class<T> clazz, Object ... params) {
        return (T)ReflectUtil.newInstance(clazz, (Object[])params);
    }

    public static final <T extends Serializable> byte[] serialize(T obj) {
        return ObjectUtil.serialize(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static final <T extends Serializable> T deserialize(byte[] bytes, Class<T> clazz, Class<?> ... acceptClasses) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            Serializable serializable;
            block10: {
                Class[] classes = (Class[])ArrayUtil.addAll((Object[][])new Class[][]{acceptClasses, {clazz}});
                ValidateObjectInputStream vis = new ValidateObjectInputStream((InputStream)is, classes);
                try {
                    serializable = (Serializable)IoUtil.readObj((ValidateObjectInputStream)vis, clazz);
                    if (Collections.singletonList(vis).get(0) == null) break block10;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(vis).get(0) != null) {
                        vis.close();
                    }
                    throw throwable;
                }
                vis.close();
            }
            return (T)serializable;
        }
        finally {
            if (Collections.singletonList(is).get(0) != null) {
                ((InputStream)is).close();
            }
        }
    }

    private static final String hashPackage(String cleanCode, String javaCode) {
        return MyCompilerUtil.fetchPackage(cleanCode) + HashUtil.fnvHash((String)javaCode);
    }

    private static final String fetchPackage(String cleanCode) {
        return ReUtil.get((String)PackageRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String fetchClassName(String cleanCode) {
        return ReUtil.get((String)ClassNameRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String hashJavaCode(String cleanCode, String javaCode) {
        String newPkg = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        return ReUtil.replaceAll((CharSequence)javaCode, (String)PackageRegex, (String)("package " + newPkg + ";"));
    }

    private static final String cleanNotes(String javaCode) {
        javaCode.replaceAll(NoteSingleLineRegex, "");
        Pattern pattern = Pattern.compile(NoteMultiLineRegex, 32);
        return pattern.matcher(javaCode).replaceAll("");
    }

    private MyCompilerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

