/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.ReUtil;
import java.util.regex.Pattern;
import net.openhft.compiler.CompilerUtils;

public final class MyCompilerUtil {
    static final String PackageRegex = "(?im)^\\s*package\\s+([^;]+);";
    static final String ClassNameRegex = "(?m)^\\s*public\\s+class\\s+(\\w+)\\b";
    static final String NoteSingleLineRegex = "//.+\\r\\n";
    static final String NoteMultiLineRegex = "/\\*.+?\\*/";

    public static final boolean addClassPath(String dir) {
        return CompilerUtils.addClassPath((String)dir);
    }

    public static final Class<?> loadClass(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.fetchPackage(cleanCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, javaCode);
    }

    public static final Class<?> loadClassByHash(ClassLoader classLoader, String javaCode) {
        String cleanCode = MyCompilerUtil.cleanNotes(javaCode);
        String packages = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        String className = packages + '.' + MyCompilerUtil.fetchClassName(cleanCode);
        String hashJavaCode = MyCompilerUtil.hashJavaCode(cleanCode, javaCode);
        return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, hashJavaCode);
    }

    private static final String hashPackage(String cleanCode, String javaCode) {
        return MyCompilerUtil.fetchPackage(cleanCode) + HashUtil.fnvHash((String)javaCode);
    }

    private static final String fetchPackage(String cleanCode) {
        return ReUtil.get((String)PackageRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String fetchClassName(String cleanCode) {
        return ReUtil.get((String)ClassNameRegex, (CharSequence)cleanCode, (int)1);
    }

    private static final String hashJavaCode(String cleanCode, String javaCode) {
        String newPkg = MyCompilerUtil.hashPackage(cleanCode, javaCode);
        return ReUtil.replaceAll((CharSequence)javaCode, (String)PackageRegex, (String)("package " + newPkg + ";"));
    }

    private static final String cleanNotes(String javaCode) {
        javaCode.replaceAll(NoteSingleLineRegex, "");
        Pattern pattern = Pattern.compile(NoteMultiLineRegex, 32);
        return pattern.matcher(javaCode).replaceAll("");
    }

    private MyCompilerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

