/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public final class MyTreeUtil
extends TreeUtil {
    public static final <T> void foreach(List<Tree<T>> tree, Consumer<Tree<T>> node) {
        if (CollUtil.isEmpty(tree)) {
            return;
        }
        for (Tree<T> item : tree) {
            node.accept(item);
            if (!CollUtil.isNotEmpty((Collection)item.getChildren())) continue;
            MyTreeUtil.foreach(item.getChildren(), node);
        }
    }

    public static final <T> List<Tree<T>> resetLevel(List<Tree<T>> tree, int level) {
        if (CollUtil.isEmpty(tree)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        for (Tree<T> node : tree) {
            node.putExtra("level", (Object)level);
            if (!CollUtil.isNotEmpty((Collection)node.getChildren())) continue;
            MyTreeUtil.resetLevel(node.getChildren(), level + 1);
        }
        return tree;
    }

    public static final <T> List<Tree<T>> getAllNodes(List<Tree<T>> tree) {
        ArrayList nodes = CollUtil.newArrayList((Object[])new Tree[0]);
        if (CollUtil.isEmpty(tree)) {
            return nodes;
        }
        for (Tree<T> node : tree) {
            nodes.add(node);
            if (!CollUtil.isNotEmpty((Collection)node.getChildren())) continue;
            nodes.addAll(MyTreeUtil.getAllNodes(node.getChildren()));
        }
        return nodes;
    }

    private MyTreeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

