/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.io.FileUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public final class MyFreemarkerUtil {
    private static final Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public static final String readFromFile(String filePath, Object value) {
        File templateFile = new File(filePath);
        FileTemplateLoader templateLoader = new FileTemplateLoader(templateFile.getParentFile());
        Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        Template template = configuration.getTemplate(FileUtil.normalize((String)FileUtil.getName((File)templateFile)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        template.process(value, (Writer)new OutputStreamWriter(out));
        return new String(out.toByteArray(), StandardCharsets.UTF_8.name());
    }

    public static final String read(String path, Object value) {
        Template template = cfg.getTemplate(FileUtil.normalize((String)path));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        template.process(value, (Writer)new OutputStreamWriter(out));
        return new String(out.toByteArray(), StandardCharsets.UTF_8.name());
    }

    public static final String read(String path, String key, Object value) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put(key, value);
        Template template = cfg.getTemplate(FileUtil.normalize((String)path));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        template.process(dataModel, (Writer)new OutputStreamWriter(out));
        return new String(out.toByteArray(), StandardCharsets.UTF_8.name());
    }

    private MyFreemarkerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        cfg.setClassicCompatible(true);
        cfg.setClassForTemplateLoading(MyFreemarkerUtil.class, File.separator);
        cfg.setClassLoaderForTemplateLoading(MyFreemarkerUtil.class.getClassLoader(), File.separator);
    }
}

