/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.selenium;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.setting.Setting;
import cn.renlm.plugins.MyCrawler.selenium.ChromeDriverPool;
import cn.renlm.plugins.MyCrawler.selenium.MyChromeDriver;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

public class ChromeDownloader
implements Downloader,
Closeable {
    private volatile ChromeDriverPool webDriverPool;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int sleepTime = 100;
    private int poolSize = 1;
    private Setting chromeSetting;

    public ChromeDownloader(Setting chromeSetting) {
        this.chromeSetting = chromeSetting;
        this.sleepTime = chromeSetting.getInt((Object)"sleepTime", Integer.valueOf(100));
        this.checkInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page download(Request request, Task task) {
        ChromeDriver webDriver;
        MyChromeDriver myChromeDriver;
        String url = request.getUrl();
        this.logger.info("downloading page " + url);
        this.checkInit();
        Page page = Page.ofFailure((Request)request);
        try {
            myChromeDriver = this.webDriverPool.get();
            webDriver = myChromeDriver.getWebDriver();
        }
        catch (Exception e) {
            e.printStackTrace();
            return page;
        }
        try {
            webDriver.get(url);
            this.addCookies((WebDriver)webDriver, url, task.getSite());
            ThreadUtil.safeSleep((long)this.sleepTime);
            if (this.chromeSetting.getBool((Object)"screenshot", Boolean.valueOf(false)).booleanValue()) {
                ChromeDriver jse = webDriver;
                Long width = (Long)jse.executeScript("return document.documentElement.scrollWidth", new Object[0]);
                Long height = (Long)jse.executeScript("return document.documentElement.scrollHeight", new Object[0]);
                webDriver.manage().window().setSize(new Dimension(width.intValue(), height.intValue()));
                String screenshotBASE64 = (String)webDriver.getScreenshotAs(OutputType.BASE64);
                request.putExtra("_MyCrawlerScreenshotBASE64Extra_", (Object)screenshotBASE64);
            }
            WebElement webElement = webDriver.findElement(By.xpath((String)"/html"));
            String content = webElement.getAttribute("outerHTML");
            page.setRawText(content);
            page.setUrl((Selectable)new PlainText(request.getUrl()));
            page.setRequest(request);
            page.setStatusCode(200);
            page.setDownloadSuccess(true);
            Page page2 = page;
            return page2;
        }
        catch (Exception e) {
            e.printStackTrace();
            Page page3 = page;
            return page3;
        }
        finally {
            this.webDriverPool.returnToPool(myChromeDriver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.webDriverPool == null) {
            ChromeDownloader chromeDownloader = this;
            synchronized (chromeDownloader) {
                this.webDriverPool = new ChromeDriverPool(this.chromeSetting, this.poolSize);
            }
        }
    }

    private void addCookies(WebDriver webDriver, String url, Site site) {
        Map cookies = site.getAllCookies();
        Map defaultCookies = site.getCookies();
        if (MapUtil.isNotEmpty((Map)defaultCookies)) {
            String domain = StrUtil.blankToDefault((CharSequence)site.getDomain(), (String)"");
            defaultCookies.forEach((name, value) -> {
                if (!cookies.containsKey(domain)) {
                    cookies.put(domain, new HashMap());
                }
                ((Map)cookies.get(domain)).put(name, value);
            });
        }
        if (MapUtil.isEmpty((Map)cookies)) {
            return;
        }
        WebDriver.Options manage = webDriver.manage();
        Set currentCookies = manage.getCookies();
        boolean addCookie = CollUtil.isEmpty((Collection)currentCookies);
        LinkedHashMap<String, Cookie> map = new LinkedHashMap<String, Cookie>();
        cookies.forEach((_domain, cookieMap) -> cookieMap.forEach((_name, _value) -> {
            String name = StrUtil.trimToNull((CharSequence)_name);
            String value = StrUtil.trimToNull((CharSequence)_value);
            String domain = StrUtil.removePrefix((CharSequence)StrUtil.trimToNull((CharSequence)_domain), (CharSequence)".");
            if (StrUtil.isNotBlank((CharSequence)name) && StrUtil.isNotBlank((CharSequence)value)) {
                Cookie cookie = new Cookie(name, value, domain, null, null);
                map.put(JSONUtil.toJsonStr((Object)cookie), cookie);
            }
        }));
        if (CollUtil.isNotEmpty((Collection)currentCookies)) {
            for (Cookie item : currentCookies) {
                Cookie cookie2;
                String name2 = StrUtil.trimToNull((CharSequence)item.getName());
                String value2 = StrUtil.trimToNull((CharSequence)item.getValue());
                String domain = StrUtil.removePrefix((CharSequence)StrUtil.trimToNull((CharSequence)item.getDomain()), (CharSequence)".");
                if (!StrUtil.isNotBlank((CharSequence)name2) || !StrUtil.isNotBlank((CharSequence)value2) || !(addCookie = !map.containsKey(JSONUtil.toJsonStr((Object)(cookie2 = new Cookie(name2, value2, domain, null, null)))))) continue;
                break;
            }
        }
        if (addCookie && MapUtil.isNotEmpty(map)) {
            manage.deleteAllCookies();
            map.forEach((jsonKey, cookie) -> manage.addCookie(cookie));
            webDriver.navigate().to(url);
        }
    }

    public void setThread(int thread) {
        this.poolSize = thread;
    }

    @Override
    public void close() throws IOException {
        this.webDriverPool.closeAll();
    }
}

