/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.ConstVal;
import cn.renlm.plugins.MyGeneratorConf;
import cn.renlm.plugins.MyUtil.MyXStreamUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.baomidou.mybatisplus.generator.type.ITypeConvertHandler;
import com.baomidou.mybatisplus.generator.type.TypeRegistry;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MyGeneratorUtil {
    private static final String excelXmlName = "excel.xml";
    private static final String mapperOutputDir = ConstVal.resourcesDir + "/mapper";
    private static final String excelXmlOutputDir = ConstVal.resourcesDir + "/excel";
    private static final String excelXmlTemplatePath = "config/Excel.xml.ftl";
    private static final String EntityTemplatePath = "config/Entity.java";
    private static final String serviceImplTemplatePath = "config/ServiceImpl.java";
    private static final String DS_CLASS_NAME = "com.baomidou.dynamic.datasource.annotation.DS";

    public static final void run(String xml) {
        GeneratorConfig conf = MyXStreamUtil.read(GeneratorConfig.class, xml);
        DataSourceConfig dsc = MyGeneratorUtil.dataSourceConfig(conf, conf.getSchema());
        conf.modules.forEach(module -> module.tables.forEach(table -> MyGeneratorUtil.create(conf, dsc, module, table)));
    }

    public static final DbInfo queryDbInfo(String schemaName, String url, String username, String password) {
        GeneratorConfig conf = new GeneratorConfig();
        conf.setUrl(url);
        conf.setUsername(username);
        conf.setPassword(password);
        DataSourceConfig dsc = MyGeneratorUtil.dataSourceConfig(conf, schemaName);
        ConfigBuilder config = new ConfigBuilder(null, dsc, null, null, null, null);
        DbInfo dbInfo = new DbInfo(dsc.getDbType(), schemaName, config.getTableInfoList());
        return dbInfo;
    }

    private static final void create(GeneratorConfig conf, DataSourceConfig dsc, final GeneratorModule module, final GeneratorTable table) {
        AutoGenerator autoGenerator = new AutoGenerator(dsc);
        autoGenerator.injection(MyGeneratorUtil.injectionConfig(conf, table));
        autoGenerator.strategy(MyGeneratorUtil.strategyConfig(conf, table));
        autoGenerator.packageInfo(MyGeneratorUtil.packageConfig(conf, module));
        autoGenerator.global(MyGeneratorUtil.globalConfig(conf, module, table));
        autoGenerator.execute((AbstractTemplateEngine)new FreemarkerTemplateEngine(){

            protected void outputCustomFile(@NotNull List<CustomFile> customFiles, @NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
                String tableName;
                if (table.configExcel) {
                    String entityName = tableInfo.getEntityName();
                    String excelXmlPath = excelXmlOutputDir + "/" + module.name + "/";
                    customFiles.forEach(customFile -> {
                        String fileName = excelXmlPath + entityName + "." + customFile.getFileName();
                        this.outputFile(new File(fileName), objectMap, customFile.getTemplatePath(), customFile.isFileOverride());
                    });
                }
                if (CollUtil.isNotEmpty((Collection)tableInfo.getFields()) && StrUtil.equals((CharSequence)(tableName = tableInfo.getName()), (CharSequence)table.getName())) {
                    for (TableField field : tableInfo.getFields()) {
                        String columnName = field.getColumnName();
                        for (GeneratorTableColumn column : table.columns) {
                            if (!StrUtil.equals((CharSequence)columnName, (CharSequence)column.getName())) continue;
                            ReflectUtil.setFieldValue((Object)field, (String)"convert", (Object)true);
                            tableInfo.getImportPackages().add(com.baomidou.mybatisplus.annotation.TableField.class.getName());
                        }
                        if (!field.isKeyFlag()) continue;
                        IdType idType = StrUtil.isBlank((CharSequence)table.idType) ? IdType.AUTO : IdType.valueOf((String)table.idType);
                        objectMap.put("idType", idType.toString());
                        if (!field.isKeyIdentityFlag()) continue;
                        ReflectUtil.setFieldValue((Object)field, (String)"keyIdentityFlag", (Object)(IdType.AUTO == idType ? 1 : 0));
                    }
                }
            }
        });
    }

    private static final DataSourceConfig dataSourceConfig(final GeneratorConfig conf, String schema) {
        DataSourceConfig dataSourceConfig = new DataSourceConfig.Builder(conf.url, conf.username, conf.password).schema(schema).typeConvertHandler(new ITypeConvertHandler(){

            @NotNull
            public IColumnType convert(GlobalConfig globalConfig, TypeRegistry typeRegistry, TableField.MetaInfo metaInfo) {
                IColumnType type = conf.getColumnType(metaInfo);
                if (type == null) {
                    return typeRegistry.getColumnType(metaInfo);
                }
                return type;
            }
        }).build();
        return dataSourceConfig;
    }

    private static final InjectionConfig injectionConfig(GeneratorConfig conf, GeneratorTable table) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> typeHandlerMap = new HashMap<String, String>();
        map.put("nameOfDS", DS_CLASS_NAME);
        map.put("dsName", conf.dsName);
        map.put("typeHandlerMap", typeHandlerMap);
        if (CollUtil.isNotEmpty(table.getColumns())) {
            for (GeneratorTableColumn column : table.getColumns()) {
                typeHandlerMap.put(column.getName(), column.getTypeHandler());
            }
        }
        HashMap<String, String> customFile = new HashMap<String, String>();
        customFile.put(excelXmlName, excelXmlTemplatePath);
        return new InjectionConfig.Builder().customMap(map).customFile(customFile).build();
    }

    private static final StrategyConfig strategyConfig(GeneratorConfig conf, GeneratorTable table) {
        boolean enableStrategyConfigMapper;
        boolean enableStrategyConfigService;
        boolean enableStrategyConfigController;
        boolean enableStrategyConfigEntity;
        boolean enableStrategyConfig = Objects.nonNull(conf) && Objects.nonNull(conf.getConfig()) && Objects.nonNull(conf.getConfig().getStrategyConfig());
        Entity.Builder builder = new StrategyConfig.Builder().addInclude(table.name).serviceBuilder().serviceImplTemplate(serviceImplTemplatePath).entityBuilder().javaTemplate(EntityTemplatePath).enableLombok().enableChainModel().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel);
        boolean bl = enableStrategyConfigEntity = enableStrategyConfig && Objects.nonNull(conf.getConfig().getStrategyConfig().getEntity());
        if (enableStrategyConfigEntity) {
            boolean enableSuperClass;
            MyGeneratorConf._Entity entity = conf.getConfig().getStrategyConfig().getEntity();
            if (StrUtil.isNotBlank((CharSequence)entity.getFormatFileName())) {
                builder.formatFileName(MyGeneratorConf.entityPlaceholder(entity.getFormatFileName()));
            }
            if (entity.isDisableSerialVersionUID()) {
                builder.disableSerialVersionUID();
            }
            if (entity.isTableFieldAnnotationEnable()) {
                builder.enableTableFieldAnnotation();
            }
            if (StrUtil.isNotBlank((CharSequence)entity.getVersionColumnName())) {
                builder.versionColumnName(entity.getVersionColumnName());
            }
            if (StrUtil.isNotBlank((CharSequence)entity.getLogicDeleteColumnName())) {
                builder.logicDeleteColumnName(entity.getLogicDeleteColumnName());
            }
            if (enableSuperClass = StrUtil.isNotBlank((CharSequence)entity.getSuperClass())) {
                builder.superClass(entity.getSuperClass());
                if (Objects.nonNull(entity.getSuperEntityColumns()) && CollUtil.isNotEmpty(entity.getSuperEntityColumns().getSuperEntityColumns())) {
                    ArrayList columns = entity.getSuperEntityColumns().getSuperEntityColumns().stream().map(it -> it.getText()).collect(Collectors.toList());
                    CollUtil.removeBlank(columns);
                    columns = CollUtil.distinct(columns);
                    if (CollUtil.isNotEmpty((Collection)columns)) {
                        builder.addSuperEntityColumns((List)columns);
                    }
                }
            }
        }
        if (table.coverEntity) {
            builder.enableFileOverride();
        }
        boolean bl2 = enableStrategyConfigController = enableStrategyConfig && Objects.nonNull(conf.getConfig().getStrategyConfig().getController()) && conf.getConfig().getStrategyConfig().getController().isEnableController();
        if (enableStrategyConfigController) {
            MyGeneratorConf._Controller controller = conf.getConfig().getStrategyConfig().getController();
            if (controller.isEnableRestStyle()) {
                builder.controllerBuilder().enableRestStyle();
            }
            if (StrUtil.isNotBlank((CharSequence)controller.getFormatFileName())) {
                builder.controllerBuilder().formatFileName(MyGeneratorConf.entityPlaceholder(controller.getFormatFileName()));
            }
        } else {
            builder.controllerBuilder().convertFileName(entityName -> "").disable();
        }
        boolean bl3 = enableStrategyConfigService = enableStrategyConfig && Objects.nonNull(conf.getConfig().getStrategyConfig().getService());
        if (enableStrategyConfigService) {
            MyGeneratorConf._Service service = conf.getConfig().getStrategyConfig().getService();
            if (StrUtil.isNotBlank((CharSequence)service.getFormatServiceFileName())) {
                builder.serviceBuilder().formatServiceFileName(MyGeneratorConf.entityPlaceholder(service.getFormatServiceFileName()));
            }
            if (StrUtil.isNotBlank((CharSequence)service.getFormatServiceImplFileName())) {
                builder.serviceBuilder().formatServiceImplFileName(MyGeneratorConf.entityPlaceholder(service.getFormatServiceImplFileName()));
            }
        }
        boolean bl4 = enableStrategyConfigMapper = enableStrategyConfig && Objects.nonNull(conf.getConfig().getStrategyConfig().getMapper());
        if (enableStrategyConfigMapper) {
            MyGeneratorConf._Mapper mapper = conf.getConfig().getStrategyConfig().getMapper();
            if (StrUtil.isNotBlank((CharSequence)mapper.getFormatMapperFileName())) {
                builder.mapperBuilder().formatMapperFileName(MyGeneratorConf.entityPlaceholder(mapper.getFormatMapperFileName()));
            }
            if (StrUtil.isNotBlank((CharSequence)mapper.getFormatXmlFileName())) {
                builder.mapperBuilder().formatXmlFileName(MyGeneratorConf.entityPlaceholder(mapper.getFormatXmlFileName()));
            }
        }
        return builder.build();
    }

    private static final PackageConfig packageConfig(GeneratorConfig conf, GeneratorModule module) {
        HashMap<OutputFile, CallSite> pathInfo = new HashMap<OutputFile, CallSite>();
        pathInfo.put(OutputFile.xml, (CallSite)((Object)(mapperOutputDir + "/" + module.name + "/")));
        PackageConfig.Builder builder = new PackageConfig.Builder().parent(module.pkg).moduleName(module.name).pathInfo(pathInfo);
        if (conf.getConfig() != null && conf.getConfig().getPackageConfig() != null) {
            MyGeneratorConf._PackageConfig packageConfig = conf.getConfig().getPackageConfig();
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getController())) {
                builder.controller(packageConfig.getController());
            }
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getServiceImpl())) {
                builder.serviceImpl(packageConfig.getServiceImpl());
            }
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getService())) {
                builder.service(packageConfig.getService());
            }
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getEntity())) {
                builder.entity(packageConfig.getEntity());
            }
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getMapper())) {
                builder.mapper(packageConfig.getMapper());
            }
            if (StrUtil.isNotBlank((CharSequence)packageConfig.getXml())) {
                builder.xml(packageConfig.getXml());
                pathInfo.put(OutputFile.xml, (CallSite)((Object)(ConstVal.resourcesDir + "/" + packageConfig.getXml() + "/" + module.name + "/")));
            }
        }
        return builder.build();
    }

    private static final GlobalConfig globalConfig(GeneratorConfig conf, GeneratorModule module, GeneratorTable table) {
        GlobalConfig.Builder globalConfigBuilder = new GlobalConfig.Builder().outputDir(ConstVal.javaDir).author(table.author).disableOpenDir().dateType(DateType.ONLY_DATE);
        if (Objects.nonNull(conf.config)) {
            if (conf.config.isSpringdoc()) {
                globalConfigBuilder.enableSpringdoc();
            }
            if (conf.config.isSwagger()) {
                globalConfigBuilder.enableSwagger();
            }
        }
        return globalConfigBuilder.build();
    }

    @XStreamAlias(value="generator")
    public static final class GeneratorConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Map<Integer, IColumnType> typeMap = Collections.synchronizedMap(new HashMap());
        @XStreamAsAttribute
        private String dsName;
        private String url;
        private String schema;
        private String username;
        private String password;
        private MyGeneratorConf config;
        @XStreamImplicit(itemFieldName="module")
        private List<GeneratorModule> modules;

        public IColumnType getColumnType(TableField.MetaInfo metaInfo) {
            List<MyGeneratorConf._JavaSqlType> javaSqlTypes;
            if (metaInfo == null || metaInfo.getJdbcType() == null) {
                return null;
            }
            String tableName = metaInfo.getTableName();
            String columnName = metaInfo.getColumnName();
            if (CollUtil.isNotEmpty(this.modules)) {
                for (GeneratorModule gm : this.modules) {
                    if (!CollUtil.isNotEmpty(gm.getTables())) continue;
                    for (GeneratorTable gt : gm.getTables()) {
                        if (!StrUtil.equals((CharSequence)tableName, (CharSequence)gt.getName()) || !CollUtil.isNotEmpty(gt.getColumns())) continue;
                        for (GeneratorTableColumn gtc : gt.getColumns()) {
                            if (!StrUtil.equals((CharSequence)columnName, (CharSequence)gtc.getName()) || !Objects.nonNull(gtc.getJavaSqlType())) continue;
                            final MyGeneratorConf._JavaSqlType jst = gtc.getJavaSqlType();
                            return new IColumnType(){

                                public String getType() {
                                    return jst.getType();
                                }

                                public String getPkg() {
                                    return jst.getPkg();
                                }
                            };
                        }
                    }
                }
            }
            if (MapUtil.isEmpty(typeMap) && this.config != null && this.config.getTypeConvert() != null && CollUtil.isNotEmpty(javaSqlTypes = this.config.getTypeConvert().getJavaSqlTypes())) {
                javaSqlTypes.forEach(type -> {
                    if (StrUtil.isNotBlank((CharSequence)type.getName()) && StrUtil.isNotBlank((CharSequence)type.getType())) {
                        Field field = ReflectUtil.getField(Types.class, (String)type.getName());
                        int javaSqlType = Convert.toInt((Object)ReflectUtil.getStaticFieldValue((Field)field));
                        typeMap.put(javaSqlType, new IColumnType(){
                            final /* synthetic */ MyGeneratorConf._JavaSqlType val$type;
                            {
                                this.val$type = _JavaSqlType2;
                            }

                            public String getType() {
                                return this.val$type.getType();
                            }

                            public String getPkg() {
                                return this.val$type.getPkg();
                            }
                        });
                    }
                });
            }
            int typeCode = metaInfo.getJdbcType().TYPE_CODE;
            return typeMap.get(typeCode);
        }

        public String getDsName() {
            return this.dsName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public MyGeneratorConf getConfig() {
            return this.config;
        }

        public List<GeneratorModule> getModules() {
            return this.modules;
        }

        public void setDsName(String dsName) {
            this.dsName = dsName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setConfig(MyGeneratorConf config) {
            this.config = config;
        }

        public void setModules(List<GeneratorModule> modules) {
            this.modules = modules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorConfig)) {
                return false;
            }
            GeneratorConfig other = (GeneratorConfig)o;
            String this$dsName = this.getDsName();
            String other$dsName = other.getDsName();
            if (this$dsName == null ? other$dsName != null : !this$dsName.equals(other$dsName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            MyGeneratorConf this$config = this.getConfig();
            MyGeneratorConf other$config = other.getConfig();
            if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
                return false;
            }
            List<GeneratorModule> this$modules = this.getModules();
            List<GeneratorModule> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dsName = this.getDsName();
            result = result * 59 + ($dsName == null ? 43 : $dsName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            MyGeneratorConf $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            List<GeneratorModule> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorConfig(dsName=" + this.getDsName() + ", url=" + this.getUrl() + ", schema=" + this.getSchema() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", config=" + this.getConfig() + ", modules=" + this.getModules() + ")";
        }
    }

    public static final class DbInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DbType dbType;
        private final String schemaName;
        private final List<TableInfo> tableInfoList;

        public DbType getDbType() {
            return this.dbType;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public List<TableInfo> getTableInfoList() {
            return this.tableInfoList;
        }

        public DbInfo(DbType dbType, String schemaName, List<TableInfo> tableInfoList) {
            this.dbType = dbType;
            this.schemaName = schemaName;
            this.tableInfoList = tableInfoList;
        }
    }

    public static final class GeneratorTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String author;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        private String idType;
        @XStreamAsAttribute
        @XStreamAlias(value="entity")
        private boolean coverEntity;
        @XStreamAsAttribute
        @XStreamAlias(value="excel")
        private boolean configExcel;
        @XStreamImplicit(itemFieldName="column")
        private List<GeneratorTableColumn> columns;

        public String getAuthor() {
            return this.author;
        }

        public String getName() {
            return this.name;
        }

        public String getIdType() {
            return this.idType;
        }

        public boolean isCoverEntity() {
            return this.coverEntity;
        }

        public boolean isConfigExcel() {
            return this.configExcel;
        }

        public List<GeneratorTableColumn> getColumns() {
            return this.columns;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdType(String idType) {
            this.idType = idType;
        }

        public void setCoverEntity(boolean coverEntity) {
            this.coverEntity = coverEntity;
        }

        public void setConfigExcel(boolean configExcel) {
            this.configExcel = configExcel;
        }

        public void setColumns(List<GeneratorTableColumn> columns) {
            this.columns = columns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorTable)) {
                return false;
            }
            GeneratorTable other = (GeneratorTable)o;
            if (this.isCoverEntity() != other.isCoverEntity()) {
                return false;
            }
            if (this.isConfigExcel() != other.isConfigExcel()) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$idType = this.getIdType();
            String other$idType = other.getIdType();
            if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
                return false;
            }
            List<GeneratorTableColumn> this$columns = this.getColumns();
            List<GeneratorTableColumn> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCoverEntity() ? 79 : 97);
            result = result * 59 + (this.isConfigExcel() ? 79 : 97);
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
            List<GeneratorTableColumn> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorTable(author=" + this.getAuthor() + ", name=" + this.getName() + ", idType=" + this.getIdType() + ", coverEntity=" + this.isCoverEntity() + ", configExcel=" + this.isConfigExcel() + ", columns=" + this.getColumns() + ")";
        }
    }

    public static final class GeneratorModule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        @XStreamAlias(value="package")
        private String pkg;
        @XStreamImplicit(itemFieldName="table")
        private List<GeneratorTable> tables;

        public String getName() {
            return this.name;
        }

        public String getPkg() {
            return this.pkg;
        }

        public List<GeneratorTable> getTables() {
            return this.tables;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public void setTables(List<GeneratorTable> tables) {
            this.tables = tables;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorModule)) {
                return false;
            }
            GeneratorModule other = (GeneratorModule)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
                return false;
            }
            List<GeneratorTable> this$tables = this.getTables();
            List<GeneratorTable> other$tables = other.getTables();
            return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            List<GeneratorTable> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorModule(name=" + this.getName() + ", pkg=" + this.getPkg() + ", tables=" + this.getTables() + ")";
        }
    }

    public static final class GeneratorTableColumn
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String name;
        private String typeHandler;
        private MyGeneratorConf._JavaSqlType javaSqlType;

        public String getName() {
            return this.name;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }

        public MyGeneratorConf._JavaSqlType getJavaSqlType() {
            return this.javaSqlType;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTypeHandler(String typeHandler) {
            this.typeHandler = typeHandler;
        }

        public void setJavaSqlType(MyGeneratorConf._JavaSqlType javaSqlType) {
            this.javaSqlType = javaSqlType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorTableColumn)) {
                return false;
            }
            GeneratorTableColumn other = (GeneratorTableColumn)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$typeHandler = this.getTypeHandler();
            String other$typeHandler = other.getTypeHandler();
            if (this$typeHandler == null ? other$typeHandler != null : !this$typeHandler.equals(other$typeHandler)) {
                return false;
            }
            MyGeneratorConf._JavaSqlType this$javaSqlType = this.getJavaSqlType();
            MyGeneratorConf._JavaSqlType other$javaSqlType = other.getJavaSqlType();
            return !(this$javaSqlType == null ? other$javaSqlType != null : !((Object)this$javaSqlType).equals(other$javaSqlType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $typeHandler = this.getTypeHandler();
            result = result * 59 + ($typeHandler == null ? 43 : $typeHandler.hashCode());
            MyGeneratorConf._JavaSqlType $javaSqlType = this.getJavaSqlType();
            result = result * 59 + ($javaSqlType == null ? 43 : ((Object)$javaSqlType).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorTableColumn(name=" + this.getName() + ", typeHandler=" + this.getTypeHandler() + ", javaSqlType=" + this.getJavaSqlType() + ")";
        }
    }
}

