/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelFileUtil;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.MyWorkbook;
import cn.renlm.plugins.MyExcel.entity.CellUnit;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import cn.renlm.plugins.MyExcel.handler.DataWriterHandler;
import cn.renlm.plugins.MyExcel.reader.AbstractReader;
import cn.renlm.plugins.MyExcel.reader.CsvReader;
import cn.renlm.plugins.MyExcel.reader.XlsReader;
import cn.renlm.plugins.MyExcel.reader.XlsxReader;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import cn.renlm.plugins.MyExcel.util.StyleUtil;
import cn.renlm.plugins.MyUtil.MyXStreamUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class MyExcelUtil {
    public static final AbstractReader read(String config, InputStream inputStream, String sheetName, DataReadHandler dataReadHandler) {
        MyWorkbook myExcel = MyXStreamUtil.read(MyWorkbook.class, config);
        if (ExcelFileUtil.isXls((InputStream)inputStream)) {
            XlsReader reader = new XlsReader(myExcel, inputStream);
            ((AbstractReader)reader).read(sheetName, dataReadHandler);
            return reader;
        }
        if (ExcelFileUtil.isXlsx((InputStream)inputStream)) {
            XlsxReader reader = new XlsxReader(myExcel, inputStream);
            ((AbstractReader)reader).read(sheetName, dataReadHandler);
            return reader;
        }
        CsvReader reader = new CsvReader(myExcel, inputStream);
        ((AbstractReader)reader).read(sheetName, dataReadHandler);
        return reader;
    }

    public static final AbstractReader readBySax(String config, InputStream inputStream, String sheetName, DataReadHandler dataReadHandler) {
        MyWorkbook myExcel = MyXStreamUtil.read(MyWorkbook.class, config);
        if (ExcelFileUtil.isXls((InputStream)inputStream)) {
            XlsReader reader = new XlsReader(myExcel, inputStream);
            ((AbstractReader)reader).readBySax(sheetName, dataReadHandler);
            return reader;
        }
        if (ExcelFileUtil.isXlsx((InputStream)inputStream)) {
            XlsxReader reader = new XlsxReader(myExcel, inputStream);
            ((AbstractReader)reader).readBySax(sheetName, dataReadHandler);
            return reader;
        }
        CsvReader reader = new CsvReader(myExcel, inputStream);
        ((AbstractReader)reader).readBySax(sheetName, dataReadHandler);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static final Workbook createWorkbook(String config, boolean isTemplate, Consumer<DataWriterHandler> ... sheet) {
        SXSSFWorkbook workbook = null;
        MyWorkbook myExcel = MyXStreamUtil.read(MyWorkbook.class, config);
        if (StrUtil.isBlankIfStr((Object)myExcel.getRef())) {
            workbook = new SXSSFWorkbook();
        } else {
            InputStream in = ResourceUtil.getStream((String)myExcel.getRef());
            try {
                workbook = new SXSSFWorkbook(new XSSFWorkbook(in));
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        for (int i = 0; i < myExcel.getSheets().size(); ++i) {
            MySheet mySheet = myExcel.getSheets().get(i);
            int level = mySheet.level();
            SXSSFSheet createSheet = workbook.createSheet(mySheet.getName());
            workbook.setSheetOrder(mySheet.getName(), i);
            List<Map<String, CellUnit>> fieldTitles = mySheet.fieldTitles(workbook, isTemplate);
            Map<String, List<Integer[]>> rowColMap = mySheet.writeSheetTitle(mySheet.getStart(), createSheet, fieldTitles);
            MergeUtil.mergeComplexTitle((Sheet)createSheet, MergeUtil.findCellRangeAddress(mySheet.getStart(), level, rowColMap));
            createSheet.createFreezePane(mySheet.getFreezes(), mySheet.getStart() + level);
            StyleUtil.createTitleAnnotation((Workbook)workbook, (Sheet)createSheet, mySheet.getStart(), fieldTitles);
            StyleUtil.createDataValidation((Sheet)createSheet, mySheet.getStart(), fieldTitles);
            StyleUtil.autoSizeColumn(createSheet, fieldTitles);
            if (i >= sheet.length) continue;
            sheet[i].accept(new DataWriterHandler(workbook, createSheet, mySheet.getStart() + level, fieldTitles));
        }
        workbook.setActiveSheet(0);
        workbook.setSelectedTab(0);
        return workbook;
    }

    private MyExcelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

