/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.scheduler;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.renlm.plugins.MyCrawler.PageUrlType;
import cn.renlm.plugins.MyCrawler.scheduler.MyDuplicateVerify;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.RedisPriorityScheduler;

public class MyRedisScheduler
extends RedisPriorityScheduler
implements MyDuplicateVerify {
    private static final String VERIFY_PREFIX = "verify_";

    public MyRedisScheduler(JedisPool jedisPool) {
        super(jedisPool);
    }

    private String getVerifyKey(Task task) {
        return VERIFY_PREFIX + task.getUUID();
    }

    @Override
    public void cleanCache(Request request, Task task) {
        String url = request.getUrl();
        String cacheKey = Base64.encode((CharSequence)url);
        try (Jedis jedis = this.pool.getResource();){
            jedis.srem(this.getSetKey(task), new String[]{url});
            jedis.srem(this.getVerifyKey(task), new String[]{url});
            jedis.del(cacheKey);
        }
    }

    @Override
    public boolean verifyDuplicate(Boolean forceUpdate, Request request, Task task) {
        String url = request.getUrl();
        int pageUrlType = (Integer)ObjectUtil.defaultIfNull((Object)((Integer)request.getExtra("_PageUrlTypeExtra_")), (Object)PageUrlType.unknown.value());
        try (Jedis jedis = this.pool.getResource();){
            boolean duplicate;
            String cacheKey = Base64.encode((CharSequence)url);
            if (NumberUtil.equals((long)pageUrlType, (long)PageUrlType.enterurl.value())) {
                this.cleanCache(request, task);
                boolean bl = false;
                return bl;
            }
            if (NumberUtil.equals((long)pageUrlType, (long)PageUrlType.seed.value())) {
                duplicate = jedis.exists(cacheKey);
                if (BooleanUtil.isTrue((Boolean)forceUpdate) || !duplicate) {
                    jedis.srem(this.getSetKey(task), new String[]{url});
                    jedis.setex(cacheKey, 75600L, url);
                }
                if (BooleanUtil.isTrue((Boolean)forceUpdate)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = duplicate;
                return bl;
            }
            boolean bl = duplicate = jedis.sadd(this.getVerifyKey(task), new String[]{url}) == 0L;
            if (BooleanUtil.isTrue((Boolean)forceUpdate)) {
                jedis.srem(this.getSetKey(task), new String[]{url});
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = duplicate;
            return bl3;
        }
    }
}

